/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.data;

import cern.accsoft.steering.jmad.domain.result.tfs.TfsResult;
import cern.accsoft.steering.jmad.domain.var.MadxVariable;
import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.domain.var.enums.MadxTwissVariable;
import cern.accsoft.steering.jmad.gui.mark.MarkerXProvider;
import cern.jdve.data.AbstractDataSet;
import cern.jdve.data.DataSet;
import cern.jdve.event.DataSetEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsResultDataSet
extends AbstractDataSet
implements MarkerXProvider {
    private static final Logger logger = LoggerFactory.getLogger(TfsResultDataSet.class);
    public static final MadxTwissVariable LABEL_VAR = MadxTwissVariable.NAME;
    private static final double LIMIT_ZERO = 1.0E-20;
    private double maxAperture = 0.0;
    private TfsResult tfsResult = null;
    private TfsResult referenceTfsResult = null;
    private double factor = 1.0;
    private TfsResultDataSetType type = TfsResultDataSetType.ABSOLUTE;
    private List<Double> xValues = new ArrayList<Double>();
    private List<Double> yValues = new ArrayList<Double>();
    private MadxVariable xVar = null;
    private TwissVariable yVar = null;

    public TfsResultDataSet(String name, MadxVariable xVar, TwissVariable yVar, TfsResultDataSetType type, TfsResult tfsResult, TfsResult referenceTfsResult) {
        super(name);
        this.xVar = xVar;
        this.yVar = yVar;
        this.type = type;
        this.tfsResult = tfsResult;
        this.referenceTfsResult = referenceTfsResult;
        this.calculate();
    }

    public void add(int arg0, double arg1, double arg2) {
        throw new UnsupportedOperationException("not implemented.");
    }

    public int getDataCount() {
        if (this.tfsResult == null) {
            return 0;
        }
        List stringData = this.tfsResult.getStringData(this.xVar);
        if (stringData != null) {
            return stringData.size();
        }
        return 0;
    }

    public double getX(int index) {
        return this.xValues.get(index);
    }

    public double getY(int index) {
        return this.yValues.get(index);
    }

    public void remove(int arg0, int arg1) {
        throw new UnsupportedOperationException("not implemented.");
    }

    public String getDataLabel(int index) {
        if (this.tfsResult == null) {
            return null;
        }
        List stringData = this.tfsResult.getStringData((MadxVariable)LABEL_VAR);
        if (stringData != null) {
            return (String)stringData.get(index);
        }
        logger.error("No data in TfsResult for variable '" + LABEL_VAR + "'.");
        return null;
    }

    private void calculate() {
        int i;
        if (this.tfsResult == null) {
            logger.error("No tfs result set.");
            return;
        }
        List xVals = this.tfsResult.getDoubleData(this.xVar);
        List yVals = this.tfsResult.getDoubleData((MadxVariable)this.yVar);
        if (xVals == null || yVals == null) {
            logger.error("No x- or no y- values found in tfs result.");
            return;
        }
        this.xValues = new ArrayList<Double>(xVals);
        this.yValues = new ArrayList<Double>(yVals);
        if (this.isApertureDataSet()) {
            this.calcMaxAperture(yVals);
            this.yValues = new ArrayList<Double>(yVals.size());
            for (i = 0; i < yVals.size(); ++i) {
                Double value = (Double)yVals.get(i);
                double absValue = Math.abs(value);
                if (absValue > this.getMaxAperture()) {
                    value = Math.signum(value) * this.getMaxAperture();
                } else if (absValue < 1.0E-20) {
                    value = this.getMaxAperture();
                }
                this.yValues.add(value);
            }
        } else if (this.isRelative()) {
            boolean refOk = true;
            List yRefValues = null;
            if (this.referenceTfsResult == null) {
                logger.warn("Should be relative dataset, but no reference set. Data will be absolute.");
                refOk = false;
            }
            if (refOk && (yRefValues = this.referenceTfsResult.getDoubleData((MadxVariable)this.yVar)) == null) {
                logger.warn("No reference values for variable '" + this.yVar + "'. Data will be absolute.");
                refOk = false;
            }
            if (refOk && yVals.size() != yRefValues.size()) {
                logger.warn("y-values and ref values are of different size. Data will be absolute.");
                refOk = false;
            }
            if (refOk) {
                this.yValues = new ArrayList<Double>(yVals.size());
                for (int i2 = 0; i2 < yVals.size(); ++i2) {
                    Double value = (Double)yVals.get(i2);
                    Double refValue = (Double)yRefValues.get(i2);
                    if (refValue != null) {
                        if (TfsResultDataSetType.DIFFERENCE.equals((Object)this.type)) {
                            value = value - refValue;
                        } else if (TfsResultDataSetType.RELATIVE.equals((Object)this.type)) {
                            value = value / refValue;
                        } else if (TfsResultDataSetType.BEATING.equals((Object)this.type)) {
                            value = (value - refValue) / refValue;
                        }
                    }
                    this.yValues.add(value);
                }
            }
        }
        for (i = 0; i < this.yValues.size(); ++i) {
            this.yValues.set(i, this.yValues.get(i) * this.getFactor());
        }
    }

    private double getMaxAperture() {
        return this.maxAperture;
    }

    public void setTfsResult(TfsResult tfsResult) {
        this.tfsResult = tfsResult;
        this.fireFullChange();
    }

    public void setReferenceTfsResult(TfsResult referenceTfsResult) {
        this.referenceTfsResult = referenceTfsResult;
        if (this.isRelative()) {
            this.fireFullChange();
        }
    }

    private boolean isRelative() {
        return !TfsResultDataSetType.ABSOLUTE.equals((Object)this.type);
    }

    private void fireFullChange() {
        this.calculate();
        this.initRanges();
        this.fireDataSetChanged(new DataSetEvent((DataSet)this, 4));
    }

    private void calcMaxAperture(List<Double> values) {
        double maxAbsValue = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            double value = Math.abs(values.get(i));
            if (!(value > maxAbsValue)) continue;
            maxAbsValue = value;
        }
        this.maxAperture = maxAbsValue;
    }

    @Override
    public List<Double> getXPositions(String elementName) {
        ArrayList<Double> xPositions = new ArrayList<Double>();
        if (this.tfsResult == null) {
            return xPositions;
        }
        Integer index = this.tfsResult.getElementIndex(elementName);
        if (index != null) {
            xPositions.add(this.xValues.get(index));
        }
        return xPositions;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }

    public boolean isApertureDataSet() {
        return this.yVar.isApertureVariable();
    }

    public static enum TfsResultDataSetType {
        ABSOLUTE,
        DIFFERENCE,
        RELATIVE,
        BEATING;

    }
}

