/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui;

import cern.accsoft.steering.jmad.gui.JMad;
import javax.swing.UIManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMadMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMadMain.class);

    public static void main(String[] args) {
        JMadMain.configureLogger();
        JMadMain.setupLookAndFeel();
        JMad.createStandaloneJMad().getJMadGui().showGui();
    }

    private static void configureLogger() {
        BasicConfigurator.configure();
        RootLogger.getRootLogger().setLevel(Level.INFO);
        Thread.setDefaultUncaughtExceptionHandler((th, e) -> LOGGER.error("Unhandled {} in thread {}: {}", new Object[]{e.getClass().getSimpleName(), th.getName(), e.getMessage(), e}));
    }

    private static void setupLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

