/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.fit;

import cern.accsoft.steering.util.fit.DataViewerFit;
import cern.jdve.data.DataSet;
import cern.jdve.data.DefaultDataSet;
import cern.jdve.utils.DataRange;
import cern.jdve.utils.DisplayPoint;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SineFit
implements DataViewerFit {
    private static final Logger logger = LoggerFactory.getLogger(SineFit.class);
    public static final String PARAM_NAME_AMPLITUDE = "amplitude";
    public static final String PARAM_NAME_FREQUENCY = "frequency";
    public static final String PARAM_NAME_PHASE = "phase";
    public static final int PARAM_INDEX_AMPLITUDE = 0;
    public static final int PARAM_INDEX_FREQUENCY = 1;
    public static final int PARAM_INDEX_PHASE = 2;
    private List<DisplayPoint> displayPoints = new ArrayList<DisplayPoint>();
    private SineFunction lastFit;

    public SineFit(List<DisplayPoint> displayPoints) {
        this.displayPoints = displayPoints;
    }

    public double valueOf(double[] params) {
        int nPoints = this.displayPoints.size();
        SineFunction sine = new SineFunction(params[0], params[1], params[2]);
        double sum = 0.0;
        for (DisplayPoint point : this.displayPoints) {
            sum += Math.pow(point.getY() - sine.valueAt(point.getX()), 2.0);
        }
        if (nPoints > 1) {
            sum /= (double)(nPoints - 1);
        }
        return Math.sqrt(sum);
    }

    @Override
    public DataSet getResultDataSet(DataRange range, int nPoints) {
        SineFunction sine = this.getLastFit();
        if (sine == null) {
            logger.warn("No fitted function available. Either the fit was not performed, or it did not give a valid result.");
            return new DefaultDataSet("Sine fit", new double[0], new double[0]);
        }
        double step = range.getLength() / (double)(nPoints - 1);
        double[] xValues = new double[nPoints];
        double[] yValues = new double[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            double xValue;
            xValues[i] = xValue = range.getMin() + step * (double)i;
            yValues[i] = sine.valueAt(xValue);
        }
        return new DefaultDataSet("Sine fit", xValues, yValues);
    }

    public void doFit() {
    }

    public SineFunction getLastFit() {
        return this.lastFit;
    }

    private class SineFunction {
        private double amplitude;
        private double frequency;
        private double phase;

        private SineFunction(double amplitude, double frequency, double phase) {
            this.amplitude = amplitude;
            this.frequency = frequency;
            this.phase = phase;
        }

        private double valueAt(double x) {
            return this.amplitude * Math.sin(Math.PI * 2 * (this.frequency * x + this.phase));
        }

        public String toString() {
            return "amplitude: " + this.amplitude + "; frequency: " + this.frequency + "; phase: " + this.phase + ";";
        }
    }
}

