/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util;

import java.text.NumberFormat;

public class StatUtil {
    private static final NumberFormat formatter = NumberFormat.getInstance();

    private StatUtil() {
    }

    public static final String createMeanRmsString(double[] values) {
        double mean = StatUtil.calcMean(values);
        double rms = StatUtil.calcRms(values);
        double meanrms = StatUtil.calcStandardDeviation(values, mean);
        String outString = "rms=" + formatter.format(rms) + "; mean=" + formatter.format(mean) + ";  stddev=" + formatter.format(meanrms);
        return outString;
    }

    public static final double calcMean(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        if (values.length > 0) {
            return sum / (double)values.length;
        }
        return 0.0;
    }

    public static final double calcRms(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += Math.pow(values[i], 2.0);
        }
        if (values.length > 0) {
            sum /= (double)values.length;
        }
        return Math.sqrt(sum);
    }

    public static final double calcStandardDeviation(double[] values, double meanValue) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += Math.pow(values[i] - meanValue, 2.0);
        }
        if (values.length > 1) {
            sum /= (double)(values.length - 1);
        }
        return Math.sqrt(sum);
    }

    static {
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(6);
    }
}

