/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels.elements;

import cern.accsoft.steering.jmad.domain.optics.OpticPoint;
import cern.accsoft.steering.jmad.domain.types.enums.JMadPlane;
import cern.accsoft.steering.jmad.domain.var.enums.JMadTwissVariable;
import cern.accsoft.steering.util.gui.dv.ds.ListDataSet;
import java.util.ArrayList;
import java.util.List;

public class PhaseSpaceDataSet
extends ListDataSet {
    private static final long serialVersionUID = 1L;
    private boolean normalized = true;
    private JMadPlane plane = JMadPlane.H;
    private List<OpticPoint> opticsPoints = new ArrayList<OpticPoint>();

    public PhaseSpaceDataSet(String name, JMadPlane plane) {
        super(name);
        this.plane = plane;
    }

    private void recalc() {
        ArrayList<Double> xValues = new ArrayList<Double>();
        ArrayList<Double> yValues = new ArrayList<Double>();
        for (OpticPoint opticPoint : this.opticsPoints) {
            double pos = opticPoint.getValue(JMadTwissVariable.POS, this.plane);
            double angle = opticPoint.getValue(JMadTwissVariable.P, this.plane);
            if (this.isNormalized()) {
                double sqrtBeta = Math.sqrt(opticPoint.getValue(JMadTwissVariable.BETA, this.plane));
                double normalizedPos = pos / sqrtBeta;
                double normalizedAngle = normalizedPos * opticPoint.getValue(JMadTwissVariable.ALFA, this.plane) + sqrtBeta * angle;
                xValues.add(normalizedPos);
                yValues.add(normalizedAngle);
                continue;
            }
            xValues.add(pos);
            yValues.add(angle);
        }
        super.setValues(xValues, yValues);
    }

    private void updateLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (OpticPoint opticPoint : this.opticsPoints) {
            labels.add(opticPoint.getName());
        }
        super.setLabels(labels);
    }

    public synchronized void setOpticsPoints(List<OpticPoint> opticsPoints) {
        this.opticsPoints = opticsPoints;
        this.updateLabels();
        this.recalc();
    }

    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
        this.recalc();
    }

    public boolean isNormalized() {
        return this.normalized;
    }
}

