/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.machine.Range;
import cern.accsoft.steering.jmad.domain.machine.RangeListener;
import cern.accsoft.steering.jmad.domain.misalign.Misalignment;
import cern.accsoft.steering.jmad.domain.misalign.MisalignmentConfiguration;
import cern.accsoft.steering.jmad.gui.components.DoubleTableCellRenderer;
import cern.accsoft.steering.jmad.model.AbstractJMadModelListener;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelListener;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.util.gui.CompUtils;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import cern.accsoft.steering.util.gui.table.BeanTableEditHandler;
import cern.accsoft.steering.util.gui.table.BeanTableModel;
import cern.accsoft.steering.util.gui.table.SelectionSetTableModel;
import cern.accsoft.steering.util.gui.table.TableModelSelectionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMisalignmentsPanel
extends JPanel {
    private static final long serialVersionUID = -2761017481167940042L;
    private static final Logger logger = LoggerFactory.getLogger(ModelMisalignmentsPanel.class);
    private static final int DIVIDER_LOCATION = 150;
    private JMadModelManager modelManager;
    private MisalignmentsTableModel misalignmentsTableModel;
    private BeanTableModel misalignmentTableModel;
    private JTextField txtElementName = null;
    private JMadModelListener modelListener = new AbstractJMadModelListener(){

        public void rangeChanged(Range newRange) {
            newRange.addListener(new RangeListener(){

                public void addedMisalignments(MisalignmentConfiguration misalignmentConfiguration) {
                    ModelMisalignmentsPanel.this.misalignmentsTableModel.fireTableDataChanged();
                    ModelMisalignmentsPanel.this.validate();
                }

                public void addedMisalignments(List<MisalignmentConfiguration> arg0) {
                    ModelMisalignmentsPanel.this.misalignmentsTableModel.fireTableDataChanged();
                    ModelMisalignmentsPanel.this.validate();
                }
            });
            ModelMisalignmentsPanel.this.misalignmentsTableModel.fireTableDataChanged();
            ModelMisalignmentsPanel.this.validate();
        }

        public void becameDirty() {
        }
    };

    public void init() {
        this.initComponents();
    }

    private final void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        this.misalignmentsTableModel = new MisalignmentsTableModel();
        JTable table = new JTable(this.misalignmentsTableModel);
        table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        table.setAutoCreateRowSorter(true);
        table.getSelectionModel().addListSelectionListener(new MisalignmentsSelectionAdapter(table));
        table.getSelectionModel().setSelectionMode(2);
        this.misalignmentsTableModel.setTableModelSelectionAdapter(new TableModelSelectionAdapter(table));
        JScrollPane elementsScrollPane = CompUtils.createScrollPane(table);
        listPanel.add((Component)new TableFilterPanel(table), constraints);
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        listPanel.add((Component)elementsScrollPane, constraints);
        JPanel detailPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        this.txtElementName = new JTextField();
        this.txtElementName.setEditable(false);
        detailPanel.add((Component)this.txtElementName, constraints);
        constraints.weighty = 1.0;
        ++constraints.gridy;
        this.misalignmentTableModel = new BeanTableModel(Misalignment.class);
        this.misalignmentTableModel.setEditable(true);
        table = new JTable(this.misalignmentTableModel);
        detailPanel.add((Component)CompUtils.createScrollPane(table), constraints);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(listPanel);
        splitPane.setRightComponent(detailPanel);
        this.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(150);
    }

    private void setCurrentMisalignment(int index) {
        if (index >= 0 && this.modelManager != null && index < this.getMisalignmentConfigurations().size()) {
            MisalignmentConfiguration misalignmentConfiguration = this.getMisalignmentConfigurations().get(index);
            this.txtElementName.setText(misalignmentConfiguration.getElementName());
            this.misalignmentTableModel.setBean(misalignmentConfiguration.getMisalignment());
        }
    }

    private List<MisalignmentConfiguration> getMisalignmentConfigurations() {
        if (this.getModelManager() == null || this.getModelManager().getActiveModel() == null || this.getModelManager().getActiveModel().getActiveRange() == null) {
            return new ArrayList<MisalignmentConfiguration>();
        }
        return this.getModelManager().getActiveModel().getActiveRange().getMisalignmentConfigurations();
    }

    private List<Misalignment> getSelectedMisalignments() {
        ArrayList<Misalignment> misalignments = new ArrayList<Misalignment>();
        List<MisalignmentConfiguration> configurations = this.getMisalignmentConfigurations();
        List<Integer> indizes = this.misalignmentsTableModel.getTableModelSelectionAdapter().getSelectedRowIndizes();
        for (Integer index : indizes) {
            misalignments.add(configurations.get(index).getMisalignment());
        }
        return misalignments;
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        if (this.modelManager.getActiveModel() != null) {
            this.modelManager.getActiveModel().addListener(this.modelListener);
        }
        modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newModel) {
                if (newModel != null) {
                    newModel.addListener(ModelMisalignmentsPanel.this.modelListener);
                }
                ModelMisalignmentsPanel.this.misalignmentsTableModel.fireTableDataChanged();
            }
        });
    }

    private JMadModelManager getModelManager() {
        if (this.modelManager == null) {
            logger.warn("model manager not set. Maybe config error.");
        }
        return this.modelManager;
    }

    public void setEditHandler(BeanTableEditHandler editHandler) {
        this.misalignmentTableModel.setEditHandler(new EditHandlerAdapter(editHandler));
    }

    private class EditHandlerAdapter
    implements BeanTableEditHandler {
        private BeanTableEditHandler parent;

        private EditHandlerAdapter(BeanTableEditHandler parent) {
            this.parent = parent;
        }

        @Override
        public Boolean getCheckValue(Object bean, String propertyName) {
            return this.parent.getCheckValue(bean, propertyName);
        }

        @Override
        public String getCheckableColumnHeader() {
            return this.parent.getCheckableColumnHeader();
        }

        @Override
        public void setCheckValue(Object bean, String propertyName, boolean value) {
            List misalignments = ModelMisalignmentsPanel.this.getSelectedMisalignments();
            for (Misalignment misalignment : misalignments) {
                this.parent.setCheckValue(misalignment, propertyName, value);
            }
        }

        @Override
        public boolean isEditable() {
            return false;
        }
    }

    private class MisalignmentsSelectionAdapter
    implements ListSelectionListener {
        private JTable table = null;

        public MisalignmentsSelectionAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            int index;
            if (event.getSource() == this.table.getSelectionModel() && (index = this.table.getSelectedRow()) >= 0) {
                ModelMisalignmentsPanel.this.setCurrentMisalignment(this.table.convertRowIndexToModel(index));
            }
        }
    }

    private class MisalignmentsTableModel
    extends SelectionSetTableModel {
        private static final long serialVersionUID = -5686224769800416136L;
        private static final int COL_COUNT = 1;
        private static final int COL_INDEX_NAME = 0;

        private MisalignmentsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ModelMisalignmentsPanel.this.getMisalignmentConfigurations().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (0 == col) {
                return ((MisalignmentConfiguration)ModelMisalignmentsPanel.this.getMisalignmentConfigurations().get(row)).getElementName();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "element name";
                }
            }
            return null;
        }
    }
}

