/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.gui.actions.JMadGuiActions;
import cern.accsoft.steering.jmad.gui.panels.ComparisonPanel;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.util.gui.CompUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ModelManagerPanel
extends JPanel {
    private static final long serialVersionUID = -244842549979376608L;
    private JMadModelManager modelManager;
    private ModelManagerTableModel tableModel;
    private JMadGuiActions jmadGuiActions;
    private JTable table;
    private ComparisonPanel comparisonPanel;
    private JMadModelManagerListener modelManagerListener = new JMadModelManagerListener(){

        public void removedModel(JMadModel removedModel) {
            ModelManagerPanel.this.tableModel.fireTableDataChanged();
        }

        public void changedActiveModel(JMadModel newActiveModel) {
            ModelManagerPanel.this.setSelectedModel(newActiveModel);
        }

        public void addedModel(JMadModel newModel) {
            ModelManagerPanel.this.tableModel.fireTableDataChanged();
        }
    };

    public void init() {
        Objects.requireNonNull(this.comparisonPanel, "comparisonPanel");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new ModelManagerTableModel();
        this.table = new JTable(this.tableModel);
        this.setSelectedModel(this.getModelManager().getActiveModel());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int modelIndex = ModelManagerPanel.this.table.convertRowIndexToModel(ModelManagerPanel.this.table.getSelectedRow());
                if (modelIndex < 0) {
                    return;
                }
                final JMadModel selectedModel = ModelManagerPanel.this.tableModel.getModel(modelIndex);
                if (e.getButton() == 3) {
                    JMenuItem switchToActive = new JMenuItem("Set as active model");
                    switchToActive.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.setAsActiveModel(selectedModel);
                        }
                    });
                    JMenuItem compareToActive = new JMenuItem("Compare to the active model");
                    compareToActive.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JMadModel activeModel = ModelManagerPanel.this.modelManager.getActiveModel();
                            ModelManagerPanel.this.comparisonPanel.compareTwoModels(activeModel, selectedModel);
                            JFrame frame = new JFrame("Comparison for models");
                            frame.add(ModelManagerPanel.this.comparisonPanel);
                            frame.setSize(800, 600);
                            frame.setVisible(true);
                            frame.setDefaultCloseOperation(2);
                        }
                    });
                    JPopupMenu menu = new JPopupMenu();
                    menu.setVisible(true);
                    menu.add(switchToActive);
                    menu.add(compareToActive);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                if (e.getButton() == 1 && e.getClickCount() > 1) {
                    this.setAsActiveModel(selectedModel);
                }
            }

            protected void setAsActiveModel(JMadModel selectedModel) {
                if (selectedModel != null && !selectedModel.equals(ModelManagerPanel.this.getModelManager().getActiveModel())) {
                    ModelManagerPanel.this.getModelManager().setActiveModel(selectedModel);
                }
            }
        });
        this.getModelManager().addListener(this.modelManagerListener);
        this.add((Component)CompUtils.createScrollPane(this.table), "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        JButton newModelBtn = new JButton(this.jmadGuiActions.getCreateModelAction());
        newModelBtn.setText(null);
        buttonPanel.add((Component)newModelBtn, constraints);
        ++constraints.gridx;
        JButton closeActiveModelBtn = new JButton(this.jmadGuiActions.getCloseActiveModelAction());
        closeActiveModelBtn.setText(null);
        buttonPanel.add((Component)closeActiveModelBtn, constraints);
        this.add((Component)buttonPanel, "South");
    }

    private void setSelectedModel(JMadModel model) {
        if (model == null) {
            return;
        }
        Integer index = this.getTableModelIndex(model);
        if (index != null) {
            int tableIndex = this.table.convertRowIndexToView(index);
            this.table.setRowSelectionInterval(tableIndex, tableIndex);
        }
    }

    private Integer getTableModelIndex(JMadModel model) {
        if (model == null) {
            return null;
        }
        int count = 0;
        for (JMadModel jmadModel : this.getModelManager().getModels()) {
            if (model.equals(jmadModel)) {
                return count;
            }
            ++count;
        }
        return null;
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
    }

    private JMadModelManager getModelManager() {
        return this.modelManager;
    }

    public void setComparisonPanel(ComparisonPanel comparisonPanel) {
        this.comparisonPanel = comparisonPanel;
    }

    public void setJmadGuiActions(JMadGuiActions jmadGuiActions) {
        this.jmadGuiActions = jmadGuiActions;
    }

    private class ModelManagerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int COL_COUNT = 1;
        private static final int COL_IDX_NAME = 0;

        private ModelManagerTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ModelManagerPanel.this.getModelManager().getModels().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            JMadModel model = this.getModel(row);
            if (col == 0) {
                return model.getName();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return String.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "name";
            }
            return super.getColumnName(col);
        }

        private JMadModel getModel(int row) {
            return (JMadModel)ModelManagerPanel.this.getModelManager().getModels().get(row);
        }
    }
}

