/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.executor;

import cern.accsoft.steering.jmad.gui.executor.ActiveJobsEvent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class AsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutor.class);
    private static final int JOBS_WARN_LEVEL = 20;
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("async-executor-%d").build());
    private final AtomicInteger jobsCount = new AtomicInteger(0);
    private final ApplicationEventPublisher eventPublisher;

    public AsyncExecutor(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void submitAsync(Runnable job) {
        this.submitAsync("unnamed-job-" + Instant.now(), job);
    }

    public void submitAsync(String name, Runnable job) {
        if (this.jobsCount.get() >= 20) {
            LOGGER.warn("Active jobs count >= {}. No limit is enforced, but performance may suffer", (Object)20);
        }
        LOGGER.info("Starting job '{}' ...", (Object)name);
        this.publishJobsCount(this.jobsCount.incrementAndGet());
        CompletableFuture<Void> future = CompletableFuture.runAsync(job, this.executor);
        future.whenComplete((res, exc) -> {
            this.publishJobsCount(this.jobsCount.decrementAndGet());
            if (exc == null) {
                LOGGER.info("Job '{}' completed.", (Object)name);
            } else {
                LOGGER.error("Error in job '{}': {}", new Object[]{name, exc.getMessage(), exc});
            }
        });
    }

    private void publishJobsCount(int count) {
        this.eventPublisher.publishEvent((Object)new ActiveJobsEvent(count));
    }
}

