/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.tree;

import cern.accsoft.steering.util.gui.tree.FileNode;
import cern.accsoft.steering.util.gui.tree.IconCellRenderer;
import cern.accsoft.steering.util.gui.tree.IconData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FileTree
extends JFrame {
    private static final long serialVersionUID = -5963248929237795732L;
    public static final ImageIcon ICON_COMPUTER = new ImageIcon("computer.gif");
    public static final ImageIcon ICON_DISK = new ImageIcon("disk.gif");
    public static final ImageIcon ICON_FOLDER = new ImageIcon("folder.gif");
    public static final ImageIcon ICON_EXPANDEDFOLDER = new ImageIcon("expandedfolder.gif");
    protected JTree m_tree;
    protected DefaultTreeModel m_model;
    protected JTextField m_display;
    protected JPopupMenu m_popup;
    protected Action m_action;
    protected TreePath m_clickedPath;

    public FileTree() {
        super("Directories Tree [Popup Menus]");
        this.setSize(400, 300);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new IconData(ICON_COMPUTER, null, "Computer"));
        File[] roots = File.listRoots();
        for (int k = 0; k < roots.length; ++k) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(ICON_DISK, null, new FileNode(roots[k])));
            top.add(node);
            node.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        this.m_model = new DefaultTreeModel(top);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer renderer = new IconCellRenderer();
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.addTreeExpansionListener(new DirExpansionListener());
        this.m_tree.addTreeSelectionListener(new DirSelectionListener());
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        JScrollPane s = new JScrollPane();
        s.getViewport().add(this.m_tree);
        this.getContentPane().add((Component)s, "Center");
        this.m_display = new JTextField();
        this.m_display.setEditable(false);
        this.getContentPane().add((Component)this.m_display, "North");
        this.m_popup = new JPopupMenu();
        this.m_action = new AbstractAction(){
            private static final long serialVersionUID = 5047958263478433364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileTree.this.m_clickedPath == null) {
                    return;
                }
                if (FileTree.this.m_tree.isExpanded(FileTree.this.m_clickedPath)) {
                    FileTree.this.m_tree.collapsePath(FileTree.this.m_clickedPath);
                } else {
                    FileTree.this.m_tree.expandPath(FileTree.this.m_clickedPath);
                }
            }
        };
        this.m_popup.add(this.m_action);
        this.m_popup.addSeparator();
        AbstractAction a1 = new AbstractAction("Delete"){
            private static final long serialVersionUID = 4068668545164395276L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTree.this.m_tree.repaint();
                JOptionPane.showMessageDialog(FileTree.this, "Delete option is not implemented", "Info", 1);
            }
        };
        this.m_popup.add(a1);
        AbstractAction a2 = new AbstractAction("Rename"){
            private static final long serialVersionUID = -2379914044256599884L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTree.this.m_tree.repaint();
                JOptionPane.showMessageDialog(FileTree.this, "Rename option is not implemented", "Info", 1);
            }
        };
        this.m_popup.add(a2);
        this.m_tree.add(this.m_popup);
        this.m_tree.addMouseListener(new PopupTrigger());
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        this.addWindowListener(wndCloser);
        this.setVisible(true);
    }

    DefaultMutableTreeNode getTreeNode(TreePath path) {
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    FileNode getFileNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (obj instanceof IconData) {
            obj = ((IconData)obj).getObject();
        }
        if (obj instanceof FileNode) {
            return (FileNode)obj;
        }
        return null;
    }

    public static void main(String[] argv) {
        new FileTree();
    }

    class DirSelectionListener
    implements TreeSelectionListener {
        DirSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = FileTree.this.getTreeNode(event.getPath());
            FileNode fnode = FileTree.this.getFileNode(node);
            if (fnode != null) {
                FileTree.this.m_display.setText(fnode.getFile().getAbsolutePath());
            } else {
                FileTree.this.m_display.setText("");
            }
        }
    }

    class DirExpansionListener
    implements TreeExpansionListener {
        DirExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            final DefaultMutableTreeNode node = FileTree.this.getTreeNode(event.getPath());
            final FileNode fnode = FileTree.this.getFileNode(node);
            Thread runner = new Thread(){

                @Override
                public void run() {
                    if (fnode != null && fnode.expand(node)) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                FileTree.this.m_model.reload(node);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            };
            runner.start();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int y;
            int x;
            TreePath path;
            if (e.isPopupTrigger() && (path = FileTree.this.m_tree.getPathForLocation(x = e.getX(), y = e.getY())) != null) {
                if (FileTree.this.m_tree.isExpanded(path)) {
                    FileTree.this.m_action.putValue("Name", "Collapse");
                } else {
                    FileTree.this.m_action.putValue("Name", "Expand");
                }
                FileTree.this.m_popup.show(FileTree.this.m_tree, x, y);
                FileTree.this.m_clickedPath = path;
            }
        }
    }
}

