/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.table;

import cern.accsoft.steering.util.gui.table.BeanTableEditHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTableModel
extends AbstractTableModel {
    private static final Logger logger = LoggerFactory.getLogger(BeanTableModel.class);
    private static final int COL_COUNT = 3;
    private static final int COL_INDEX_SELECTED = 0;
    private static final int COL_INDEX_NAME = 1;
    private static final int COL_INDEX_VALUE = 2;
    private static final String GETTER_PREFIX_DEFAULT = "get";
    private static final String GETTER_PREFIX_BOOLEAN = "is";
    private static final String SETTER_PREFIX = "set";
    private Class<?>[] valueClasses = new Class[]{Double.class, Double.TYPE};
    private Class<?> beanClass;
    private Object bean;
    private List<Method> getters = new ArrayList<Method>();
    private boolean editable = false;
    private BeanTableEditHandler editHandler = null;

    public BeanTableModel(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    private String getGetterPrefix() {
        if (Boolean.class.equals(this.valueClasses[0])) {
            return GETTER_PREFIX_BOOLEAN;
        }
        return GETTER_PREFIX_DEFAULT;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.getters.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            if (this.getEditHandler() != null) {
                return this.getEditHandler().getCheckValue(this.bean, this.getPropertyName(row));
            }
            return false;
        }
        if (col == 1) {
            return this.getPropertyName(row);
        }
        if (col == 2) {
            return this.getPropertyValue(row);
        }
        logger.warn("unknown column number '" + col + "'");
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return this.getValueClasses()[0];
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                if (this.getEditHandler() != null) {
                    return this.getEditHandler().getCheckableColumnHeader();
                }
                return "select";
            }
            case 1: {
                return "property name";
            }
            case 2: {
                return "value";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                if (this.getEditHandler() == null) break;
                this.getEditHandler().setCheckValue(this.getBean(), this.getPropertyName(row), (Boolean)value);
                break;
            }
            case 2: {
                this.setPropertyValue(value, row);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (0 == col) {
            return this.getEditHandler() != null && this.getEditHandler().isEditable();
        }
        if (2 == col) {
            return this.isEditable();
        }
        return false;
    }

    private void setPropertyValue(Object value, int index) {
        if (this.getBean() == null) {
            return;
        }
        Method setter = this.getSetter(index);
        if (setter == null) {
            logger.error("no setter method for property '" + this.getPropertyName(index) + "' could be found.");
            return;
        }
        try {
            setter.invoke(this.getBean(), value);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while invoking setter '" + setter.getName() + "' of bean '" + this.getBean().toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error while invoking setter '" + setter.getName() + "' of bean '" + this.getBean().toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error while invoking setter '" + setter.getName() + "' of bean '" + this.getBean().toString(), (Throwable)e);
        }
    }

    private Method getSetter(int index) {
        String getterName = this.getters.get(index).getName();
        String setterName = SETTER_PREFIX + getterName.substring(this.getGetterPrefix().length());
        Method setter = null;
        for (int i = 0; i < this.valueClasses.length; ++i) {
            Class<?> valueClass = this.valueClasses[i];
            try {
                setter = this.bean.getClass().getMethod(setterName, valueClass);
                if (setter == null) continue;
                break;
            }
            catch (SecurityException e) {
                logger.error("Error while searching for method '" + setterName + "'.", (Throwable)e);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return setter;
    }

    private String getPropertyName(int index) {
        String getterName = this.getters.get(index).getName();
        int startIndex = this.getGetterPrefix().length();
        String propertyName = getterName.substring(startIndex, startIndex + 1).toLowerCase();
        if (getterName.length() > this.getGetterPrefix().length() + 1) {
            propertyName = propertyName + getterName.substring(startIndex + 1);
        }
        return propertyName;
    }

    private Object getPropertyValue(int index) {
        if (this.getBean() == null) {
            return null;
        }
        Method method = this.getters.get(index);
        try {
            return method.invoke(this.getBean(), new Object[0]);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while invoking getter '" + method.getName() + "' of bean '" + this.getBean().toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error while invoking getter '" + method.getName() + "' of bean '" + this.getBean().toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error while invoking getter '" + method.getName() + "' of bean '" + this.getBean().toString(), (Throwable)e);
        }
        return null;
    }

    private void initGetterNames() {
        this.getters.clear();
        block0: for (Method method : this.beanClass.getMethods()) {
            String methodName;
            if (method.getParameterTypes().length > 0 || !(methodName = method.getName()).startsWith(this.getGetterPrefix()) || methodName.length() <= this.getGetterPrefix().length()) continue;
            for (int i = 0; i < this.getValueClasses().length; ++i) {
                if (!method.getReturnType().equals(this.getValueClasses()[i])) continue;
                this.getters.add(method);
                continue block0;
            }
        }
    }

    public void setBean(Object bean) {
        this.bean = bean;
        this.initGetterNames();
        this.fireTableDataChanged();
    }

    private Object getBean() {
        return this.bean;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setValueClasses(Class<?>[] valueClasses) {
        this.valueClasses = valueClasses;
    }

    public Class<?>[] getValueClasses() {
        return this.valueClasses;
    }

    public void setEditHandler(BeanTableEditHandler editHandler) {
        this.editHandler = editHandler;
    }

    public BeanTableEditHandler getEditHandler() {
        return this.editHandler;
    }
}

