/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ScriptConsole
extends JScrollPane
implements KeyListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String CUT = "Cut";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";
    private InputStream in;
    private ConsoleOutputStream out = new ConsoleOutputStream();
    private ConsoleOutputStream err = new ConsoleOutputStream();
    private PrintStream outPrintStream = new PrintStream(this.out, true);
    private PrintStream outErrStream = new PrintStream(this.err, true);
    private PrintStream defaultSystemOutput = System.out;
    private PrintStream defaultSystemError = System.err;
    private int cmdStart = 0;
    private Vector<String> history = new Vector();
    private String startedLine;
    private int histLine = 0;
    private String executionBuffer = "";
    private boolean multilineCommand = false;
    private JPopupMenu menu;
    private JTextPane text;
    private StyledDocument doc = new DefaultStyledDocument();
    private ScriptEngine scriptEngine;
    private String indentOffset;
    private boolean output_able = true;
    private MutableAttributeSet out_att = new SimpleAttributeSet();
    private MutableAttributeSet err_att = new SimpleAttributeSet();
    String ZEROS;

    public ScriptConsole() {
        this(null, null);
    }

    public ScriptConsole(InputStream cin, OutputStream cout) {
        StyleConstants.setForeground(this.out_att, Color.GREEN);
        StyleConstants.setForeground(this.err_att, Color.RED);
        this.ZEROS = "000";
        this.indentOffset = "";
        this.text = new JTextPane(this.doc){
            private static final long serialVersionUID = 1L;

            @Override
            public void cut() {
                if (ScriptConsole.this.text.getCaretPosition() < ScriptConsole.this.cmdStart) {
                    super.copy();
                } else {
                    super.cut();
                }
            }

            @Override
            public void paste() {
                ScriptConsole.this.forceCaretMoveToEnd();
                super.paste();
            }
        };
        Font font = new Font("Monospaced", 0, 12);
        this.text.setText("");
        this.text.setFont(font);
        this.text.setMargin(new Insets(7, 5, 7, 5));
        this.text.addKeyListener(this);
        this.setViewportView(this.text);
        this.menu = new JPopupMenu("JConsole\tMenu");
        this.menu.add(new JMenuItem(CUT)).addActionListener(this);
        this.menu.add(new JMenuItem(COPY)).addActionListener(this);
        this.menu.add(new JMenuItem(PASTE)).addActionListener(this);
        this.text.addMouseListener(this);
        this.requestFocus();
        this.setStyle(Color.GREEN.darker());
        this.println("Welcome the scripting console!");
        this.setStyle(Color.black);
        this.addPrompt();
    }

    public void captureSystemOut(boolean mode) {
        if (mode) {
            System.setOut(this.outPrintStream);
            System.setErr(this.outErrStream);
        } else {
            System.setOut(this.defaultSystemOutput);
            System.setErr(this.defaultSystemError);
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public Reader getIn() {
        return new InputStreamReader(this.in);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.text.requestFocus();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.type(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.type(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.type(e);
    }

    private void addPrompt() {
        this.setStyle(Color.magenta);
        if (!this.multilineCommand) {
            this.append(">>> ");
        } else {
            this.append("... ");
        }
        this.setStyle(Color.black);
        this.resetCommandStart();
    }

    private synchronized void type(KeyEvent e) {
        this.setStyle(Color.black);
        switch (e.getKeyCode()) {
            case 10: {
                if (e.getID() == 401) {
                    this.enter();
                    if (this.indentOffset.length() == 0) {
                        this.executeBuffer();
                    }
                    this.blankLine();
                    this.addPrompt();
                    this.resetCommandStart();
                    this.append(this.indentOffset);
                    this.text.setCaretPosition(this.cmdStart + this.indentOffset.length());
                }
                e.consume();
                this.text.repaint();
                break;
            }
            case 38: {
                if (e.getID() == 401) {
                    this.historyUp();
                }
                e.consume();
                break;
            }
            case 40: {
                if (e.getID() == 401) {
                    this.historyDown();
                }
                e.consume();
                break;
            }
            case 37: {
                break;
            }
            case 8: 
            case 127: {
                if (this.text.getCaretPosition() > this.cmdStart) break;
                e.consume();
                break;
            }
            case 39: {
                this.forceCaretMoveToStart();
                break;
            }
            case 36: {
                this.text.setCaretPosition(this.cmdStart);
                e.consume();
                break;
            }
            case 85: {
                if ((e.getModifiers() & 2) <= 0) break;
                this.replaceRange("", this.cmdStart, this.textLength());
                this.histLine = 0;
                e.consume();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 154: 
            case 155: 
            case 157: {
                break;
            }
            case 67: {
                if (this.text.getSelectedText() != null) break;
                if ((e.getModifiers() & 2) > 0 && e.getID() == 401) {
                    this.append("^C");
                }
                e.consume();
                break;
            }
            default: {
                if ((e.getModifiers() & 0xE) == 0) {
                    this.forceCaretMoveToEnd();
                }
                if (e.paramString().indexOf("Backspace") == -1 || this.text.getCaretPosition() > this.cmdStart) break;
                e.consume();
            }
        }
    }

    private void resetCommandStart() {
        this.cmdStart = this.textLength();
    }

    private void append(String string) {
        int slen = this.textLength();
        this.text.select(slen, slen);
        this.text.replaceSelection(string);
    }

    private String replaceRange(Object s, int start, int end) {
        String st = s.toString();
        this.text.select(start, end);
        this.text.replaceSelection(st);
        return st;
    }

    private void forceCaretMoveToEnd() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            this.text.setCaretPosition(this.textLength());
        }
        this.text.repaint();
    }

    private void forceCaretMoveToStart() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            // empty if block
        }
        this.text.repaint();
    }

    private String getIndentation(String target) {
        if (target.length() == 0) {
            return "";
        }
        if (target.startsWith(" ")) {
            return " " + this.getIndentation(target.substring(1));
        }
        return "";
    }

    private void blankLine() {
        String s = this.getCmd();
        if (s.equals(this.indentOffset + "\n")) {
            this.indentOffset = "";
        }
    }

    private void enter() {
        String s = this.getCmd();
        if (s.length() != 0) {
            this.history.addElement(s);
            s = s + "\n";
        }
        this.append("\n");
        this.histLine = 0;
        this.acceptLine(s);
        this.text.repaint();
        this.indentOffset = this.getIndentation(s);
        if (this.isJython() && s.endsWith(":\n")) {
            this.indentOffset = this.indentOffset + "    ";
        }
        this.multilineCommand = true;
    }

    private boolean isJython() {
        if (this.scriptEngine == null) {
            return false;
        }
        return this.scriptEngine.toString().equals("jython");
    }

    private String getCmd() {
        String s = "";
        try {
            s = this.text.getText(this.cmdStart, this.textLength() - this.cmdStart);
        }
        catch (BadLocationException e) {
            System.out.println("Internal JConsole Error: " + e);
        }
        return s;
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine == 0) {
            this.startedLine = this.getCmd();
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void showHistoryLine() {
        String showline = this.histLine == 0 ? this.startedLine : this.history.elementAt(this.history.size() - this.histLine);
        this.replaceRange(showline, this.cmdStart, this.textLength());
        this.text.setCaretPosition(this.textLength());
        this.text.repaint();
    }

    private void acceptLine(String line) {
        String lineOrig = line;
        this.setStyle(Color.blue);
        StringBuffer buf = new StringBuffer();
        int lineLength = line.length();
        for (int i = 0; i < lineLength; ++i) {
            String val = Integer.toString(line.charAt(i), 16);
            val = this.ZEROS.substring(0, 4 - val.length()) + val;
            buf.append("\\u" + val);
        }
        line = buf.toString();
        try {
            this.addLineToExecutionBuffer(lineOrig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStyle(Color.black);
    }

    private void addLineToExecutionBuffer(String s) {
        this.executionBuffer = this.executionBuffer + s;
    }

    private void executeBuffer() {
        this.executeCommand(this.executionBuffer);
        this.executionBuffer = "";
        this.multilineCommand = false;
        this.indentOffset = "";
    }

    public void executeCommand(String command) {
        if (this.scriptEngine == null) {
            this.print((Object)"No script engine set. Cannot execute command.\n", Color.red);
            return;
        }
        this.captureSystemOut(true);
        this.setStyle(Color.blue);
        try {
            this.scriptEngine.eval(command);
        }
        catch (ScriptException e) {
            this.setStyle(Color.red);
            e.printStackTrace();
        }
        this.setStyle(Color.black);
        this.captureSystemOut(false);
    }

    public void println(Object o) {
        this.print(String.valueOf(o) + "\n");
        this.text.repaint();
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
        AttributeSet style = this.setStyle(Color.green);
        this.println("New scriptEngine: '" + scriptEngine.getFactory().getEngineName());
        this.setStyle(style);
    }

    public void print(Object o) {
        this.print(o, null, null);
    }

    public void println() {
        this.print("\n");
        this.text.repaint();
    }

    public void error(Object o) {
        this.print(o, Color.red);
    }

    public void println(Icon icon) {
        this.print(icon);
        this.println();
        this.text.repaint();
    }

    public void print(final Icon icon) {
        if (icon == null) {
            return;
        }
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ScriptConsole.this.text.insertIcon(icon);
                ScriptConsole.this.resetCommandStart();
                ScriptConsole.this.text.setCaretPosition(ScriptConsole.this.cmdStart);
            }
        });
    }

    public void print(Object s, Font font) {
        this.print(s, font, null);
    }

    public void print(Object s, Color color) {
        this.print(s, null, color);
    }

    public void print(final Object o, final Font font, final Color color) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AttributeSet old = ScriptConsole.this.getStyle();
                ScriptConsole.this.setStyle(font, color);
                ScriptConsole.this.append(String.valueOf(o));
                ScriptConsole.this.resetCommandStart();
                ScriptConsole.this.text.setCaretPosition(ScriptConsole.this.cmdStart);
                ScriptConsole.this.setStyle(old, true);
            }
        });
    }

    public void print(Object s, String fontFamilyName, int size, Color color) {
        this.print(s, fontFamilyName, size, color, false, false, false);
    }

    public void print(final Object o, final String fontFamilyName, final int size, final Color color, final boolean bold, final boolean italic, final boolean underline) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AttributeSet old = ScriptConsole.this.getStyle();
                ScriptConsole.this.setStyle(fontFamilyName, size, color, bold, italic, underline);
                ScriptConsole.this.append(String.valueOf(o));
                ScriptConsole.this.resetCommandStart();
                ScriptConsole.this.text.setCaretPosition(ScriptConsole.this.cmdStart);
                ScriptConsole.this.setStyle(old, true);
            }
        });
    }

    private AttributeSet setStyle(Color color) {
        return this.setStyle(null, color);
    }

    private AttributeSet setStyle(Font font, Color color) {
        if (font != null) {
            return this.setStyle(font.getFamily(), font.getSize(), color, font.isBold(), font.isItalic(), StyleConstants.isUnderline(this.getStyle()));
        }
        return this.setStyle(null, -1, color);
    }

    private AttributeSet setStyle(String fontFamilyName, int size, Color color) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(attr, color);
        }
        if (fontFamilyName != null) {
            StyleConstants.setFontFamily(attr, fontFamilyName);
        }
        if (size != -1) {
            StyleConstants.setFontSize(attr, size);
        }
        this.setStyle(attr);
        return this.getStyle();
    }

    private AttributeSet setStyle(String fontFamilyName, int size, Color color, boolean bold, boolean italic, boolean underline) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(attr, color);
        }
        if (fontFamilyName != null) {
            StyleConstants.setFontFamily(attr, fontFamilyName);
        }
        if (size != -1) {
            StyleConstants.setFontSize(attr, size);
        }
        StyleConstants.setBold(attr, bold);
        StyleConstants.setItalic(attr, italic);
        StyleConstants.setUnderline(attr, underline);
        this.setStyle(attr);
        return this.getStyle();
    }

    private void setStyle(AttributeSet attributes) {
        this.setStyle(attributes, false);
    }

    private void setStyle(AttributeSet attributes, boolean overWrite) {
        this.text.setCharacterAttributes(attributes, overWrite);
    }

    private AttributeSet getStyle() {
        return this.text.getCharacterAttributes();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
    }

    @Override
    public String toString() {
        return "BeanShell console";
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.menu.show((Component)event.getSource(), event.getX(), event.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.menu.show((Component)event.getSource(), event.getX(), event.getY());
        }
        this.text.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.giveFocusToConsole();
    }

    public void giveFocusToConsole() {
        this.requestFocus();
        this.text.setCaretPosition(this.textLength());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(CUT)) {
            this.text.cut();
        } else if (cmd.equals(COPY)) {
            this.text.copy();
        } else if (cmd.equals(PASTE)) {
            this.text.paste();
        }
    }

    private void invokeAndWait(Runnable run) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            run.run();
        }
    }

    public void setWaitFeedback(boolean on) {
        if (on) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private int textLength() {
        return this.text.getDocument().getLength();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private synchronized void print(byte[] b, ConsoleOutputStream os) {
        try {
            this.doc.insertString(this.doc.getLength(), new String(b, 0, b.length), os == this.out ? this.out_att : this.err_att);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private Queue<Byte> buffer = new LinkedList<Byte>();
        private boolean closed = false;

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.buffer.offer((byte)b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            if (ScriptConsole.this.output_able) {
                Queue<Byte> queue = this.buffer;
                synchronized (queue) {
                    byte[] b = new byte[this.buffer.size()];
                    int cnt = 0;
                    while (!this.buffer.isEmpty()) {
                        b[cnt++] = this.buffer.poll();
                    }
                    ScriptConsole.this.print(b, this);
                }
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    public static class BlockingPipedInputStream
    extends PipedInputStream {
        boolean closed;

        public BlockingPipedInputStream(PipedOutputStream pout) throws IOException {
            super(pout);
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            while (this.in < 0) {
                this.notifyAll();
                try {
                    this.wait(750L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            int ret = this.buffer[this.out++] & 0xFF;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in == this.out) {
                this.in = -1;
            }
            return ret;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

