/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import cern.accsoft.steering.jmad.gui.dv.MarkableChart;
import cern.accsoft.steering.util.StatUtil;
import cern.accsoft.steering.util.gui.dv.ds.ColorConstants;
import cern.accsoft.steering.util.gui.dv.ds.DvUtils;
import cern.accsoft.steering.util.gui.dv.ds.ValidityDataSet;
import cern.jdve.ChartDecoration;
import cern.jdve.ChartRenderer;
import cern.jdve.EditionManager;
import cern.jdve.Style;
import cern.jdve.data.DataSet;
import cern.jdve.data.DataSource;
import cern.jdve.data.DefaultDataSet;
import cern.jdve.data.DefaultDataSource;
import cern.jdve.event.DataSetEvent;
import cern.jdve.event.DataSetListener;
import cern.jdve.event.DataSourceEvent;
import cern.jdve.event.DataSourceListener;
import cern.jdve.graphic.ChartAnnotation;
import cern.jdve.renderer.HiLoRenderer;
import java.awt.Color;
import java.util.ArrayList;

public class Aloha2DChart
extends MarkableChart {
    private static final long serialVersionUID = 7117238469835822463L;
    private ChartAnnotation commentAnnotation = null;
    private boolean visibleStatistics = true;

    public Aloha2DChart() {
        this.initDefaultConfig();
        this.createRenderers();
        this.createDefaultInteractors();
    }

    private void initDefaultConfig() {
        super.setAntiAliasingText(true);
    }

    public void setVisibleCategory(boolean visibleCategory) {
        super.getXScale().setLabelRotation((double)(visibleCategory ? 90 : 0));
        super.getXScale().setCategory(visibleCategory);
    }

    public boolean isVisibleCategory() {
        return super.getXScale().isCategory();
    }

    private void createRenderers() {
        this.addEmptyRenderer(this.styleRenderer(DvUtils.createBarChartRenderer(), ChartRendererRole.MEAS_DATA));
        this.addEmptyRenderer(this.styleRenderer(DvUtils.createHiLoRenderer(), ChartRendererRole.MEAS_ERROR));
        this.addEmptyRenderer(this.styleRenderer(DvUtils.createMarkerPolylineRenderer(), ChartRendererRole.MODEL_DATA));
        this.addEmptyRenderer(this.styleRenderer(DvUtils.createPolyLineRenderer(), ChartRendererRole.MEAS_FIT));
        this.addEmptyRenderer(this.styleRenderer(DvUtils.createPolyLineRenderer(), ChartRendererRole.MODEL_FIT));
    }

    private ChartRenderer styleRenderer(ChartRenderer renderer, ChartRendererRole role) {
        Color color = null;
        Color strokeColor = null;
        if (ChartRendererRole.MEAS_DATA.equals((Object)role)) {
            color = ColorConstants.COLOR_MEAS_DATA_FILL;
            strokeColor = ColorConstants.COLOR_MEAS_DATA_STROKE;
        } else if (ChartRendererRole.MEAS_ERROR.equals((Object)role)) {
            color = ColorConstants.COLOR_MEAS_ERROR_FILL;
            strokeColor = ColorConstants.COLOR_MEAS_ERROR_STROKE;
        } else if (ChartRendererRole.MODEL_DATA.equals((Object)role)) {
            color = ColorConstants.COLOR_MODEL_DATA;
            strokeColor = color.darker();
        }
        if (color != null) {
            renderer.setStyles(new Style[]{new Style(strokeColor, color)});
        }
        return renderer;
    }

    public void createDefaultInteractors() {
        DvUtils.configureDefaultInteractors(this);
    }

    private void addEmptyRenderer(ChartRenderer renderer) {
        if (renderer instanceof HiLoRenderer) {
            renderer.setDataSource((DataSource)new DefaultDataSource(new DataSet[]{this.createEmptyDataSet(), this.createEmptyDataSet()}));
        } else {
            renderer.setDataSet(this.createEmptyDataSet());
        }
        this.addRenderer(renderer);
    }

    public void setRendererDataSet(ChartRendererRole role, DataSet dataSet) {
        ChartRenderer renderer = this.getRenderer(role);
        renderer.setDataSet(dataSet);
        if (ChartRendererRole.MEAS_DATA.equals((Object)role)) {
            dataSet.addDataSetListener(new DataSetListener(){

                public void dataSetChanged(DataSetEvent evt) {
                    Aloha2DChart.this.updateStatistics();
                }
            });
        }
        this.updateStatistics();
    }

    public void setRenderDataSource(ChartRendererRole role, DataSource dataSource) {
        ChartRenderer renderer = this.getRenderer(role);
        renderer.setDataSource(dataSource);
        if (ChartRendererRole.MEAS_DATA.equals((Object)role)) {
            dataSource.addDataSourceListener(new DataSourceListener(){

                public void dataSourceChanged(DataSourceEvent evt) {
                    Aloha2DChart.this.updateStatistics();
                }
            });
        }
        this.updateStatistics();
    }

    public void clearRenderer(ChartRendererRole role) {
        this.setRendererDataSet(role, this.createEmptyDataSet());
    }

    private DataSet createEmptyDataSet() {
        return new DefaultDataSet("empty", new double[0], new double[0]);
    }

    public ChartRenderer getRenderer(ChartRendererRole role) {
        return super.getRenderer(role.ordinal());
    }

    public void setRenderer(ChartRendererRole role, ChartRenderer renderer) {
        super.setRenderer(role.ordinal(), this.styleRenderer(renderer, role));
        this.updateEditablePlots();
    }

    public void setRendererType(ChartRendererRole role, int rendererType) {
        this.setRendererType(role.ordinal(), rendererType);
    }

    public void setRendererType(ChartRendererRole role, RendererType type) {
        this.setRendererType(role, type.getDvIntValue());
    }

    public RendererType getRendererType(ChartRendererRole role) {
        int intValue = ChartRenderer.getRendererType((ChartRenderer)this.getRenderer(role));
        return RendererType.fromDvIntValue(intValue);
    }

    public void setRendererType(int index, int rendererType) {
        if (rendererType == 4) {
            this.setRenderer(index, DvUtils.createBarChartRenderer());
        } else if (rendererType == 2) {
            this.setRenderer(index, DvUtils.createMarkerPolylineRenderer());
        } else if (rendererType == 1) {
            this.setRenderer(index, DvUtils.createPolyLineRenderer());
        } else if (rendererType == 3) {
            this.setRenderer(index, DvUtils.createScatterRenderer());
        } else {
            super.setRendererType(index, rendererType);
        }
        this.updateEditablePlots();
    }

    private final void updateEditablePlots() {
        EditionManager editionManager = this.getEditionManager();
        if (editionManager != null) {
            // empty if block
        }
    }

    public ChartRendererRole getRendererRole(ChartRenderer renderer) {
        for (int i = 0; i < this.getRenderersCount(); ++i) {
            ChartRenderer chartRenderer = this.getRenderer(i);
            if (chartRenderer != renderer) continue;
            return ChartRendererRole.values()[i];
        }
        return null;
    }

    private void updateStatistics() {
        if (this.visibleStatistics) {
            if (this.commentAnnotation == null) {
                this.commentAnnotation = DvUtils.addComment(this, " ");
            }
            this.commentAnnotation.setText(this.getStatText());
        } else if (this.commentAnnotation != null) {
            this.removeDecoration((ChartDecoration)this.commentAnnotation);
            this.commentAnnotation = null;
            this.repaintChart();
        }
    }

    private String getStatText() {
        ChartRenderer dataRenderer = this.getRenderer(ChartRendererRole.MEAS_DATA);
        if (dataRenderer == null || dataRenderer.getDataSource() == null) {
            return "";
        }
        DataSet dataSet = dataRenderer.getDataSource().getDataSet(0);
        if (dataSet == null) {
            return "";
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < dataSet.getDataCount(); ++i) {
            if (dataSet instanceof ValidityDataSet && ((ValidityDataSet)dataSet).hasValidityInformation() && !((ValidityDataSet)dataSet).getValidity(i)) continue;
            values.add(dataSet.getY(i));
        }
        double[] valuesArray = new double[values.size()];
        for (int i = 0; i < valuesArray.length; ++i) {
            valuesArray[i] = (Double)values.get(i);
        }
        return StatUtil.createMeanRmsString(valuesArray);
    }

    public void setVisibleStatistics(boolean visibleStatistics) {
        this.visibleStatistics = visibleStatistics;
        this.updateStatistics();
    }

    public boolean isVisibleStatistics() {
        return this.visibleStatistics;
    }

    public static enum RendererType {
        POLYLINE(1),
        POLYLINE_WITH_MARKERS(2),
        SCATTER(3),
        BAR(4),
        IMPULSES(5),
        AREA(6),
        DIFF_AREA(7),
        STAIRS(8),
        CONTOUR(9),
        BOOLEAN(10),
        HI_LO(11);

        private int dvIntValue = 0;

        public static final RendererType fromDvIntValue(int value) {
            for (RendererType type : RendererType.values()) {
                if (type.getDvIntValue() != value) continue;
                return type;
            }
            return null;
        }

        private RendererType(int dvIntValue) {
            this.dvIntValue = dvIntValue;
        }

        public int getDvIntValue() {
            return this.dvIntValue;
        }
    }

    public static enum ChartRendererRole {
        MEAS_DATA,
        MEAS_ERROR,
        MODEL_DATA,
        MEAS_FIT,
        MODEL_FIT;

    }
}

