/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.elem.Element;
import cern.accsoft.steering.jmad.domain.elem.MadxElementType;
import cern.accsoft.steering.jmad.gui.executor.AsyncExecutor;
import cern.accsoft.steering.jmad.gui.panels.var.ElementCellRenderer;
import cern.accsoft.steering.jmad.gui.panels.var.SequenceElementsTableModel;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.service.JMadModelSeqElementOnNameComparator;
import cern.accsoft.steering.jmad.service.SequenceElementFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ComparisonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AsyncExecutor asyncExecutor;
    private SequenceElementsTableModel sequenceElementesModel1 = new SequenceElementsTableModel();
    private SequenceElementsTableModel sequenceElementesModel2 = new SequenceElementsTableModel();
    private ElementCellRenderer elementCellRenderer;
    private JComboBox<MadxElementType> filterSelection;
    private JButton loadElements;
    private JMadModelManager jMadModelManager;
    private JMadModel model1;
    private JMadModel model2;
    private JLabel labelModel2;
    private JLabel labelModel1;

    public void init() {
        Objects.requireNonNull(this.jMadModelManager, "jMadModelManager");
        this.buildGui();
    }

    public void compareTwoModels(JMadModel model1Set, JMadModel model2Set) {
        this.model1 = model1Set;
        this.model2 = model2Set;
        this.labelModel1.setText(this.model1.getName());
        this.labelModel2.setText(this.model2.getName());
        this.loadElements.setEnabled(true);
        this.fireNewDataArrived();
    }

    private void buildGui() {
        this.elementCellRenderer = new ElementCellRenderer();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sequence comparison"));
        this.add(this.createButtonsPanel(), "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel panelModel1 = new JPanel();
        JTable table = new JTable(this.sequenceElementesModel1);
        table.setDefaultRenderer(Element.class, this.elementCellRenderer);
        panelModel1.setLayout(new BorderLayout());
        this.labelModel1 = new JLabel("MODEL1 NAME");
        this.labelModel1.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        panelModel1.add((Component)this.labelModel1, "North");
        panelModel1.add((Component)new JScrollPane(table), "Center");
        panel.add(panelModel1);
        JPanel panelModel2 = new JPanel();
        JTable table2 = new JTable(this.sequenceElementesModel2);
        table2.setDefaultRenderer(Element.class, this.elementCellRenderer);
        panelModel2.setLayout(new BorderLayout());
        this.labelModel2 = new JLabel("MODEL2 NAME");
        this.labelModel2.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        panelModel2.add((Component)this.labelModel2, "North");
        panelModel2.add((Component)new JScrollPane(table2), "Center");
        panel.add(panelModel2);
        this.add((Component)panel, "Center");
    }

    private Component createButtonsPanel() {
        JPanel jPanel = new JPanel();
        this.filterSelection = new JComboBox<MadxElementType>(MadxElementType.values());
        jPanel.add(this.filterSelection);
        this.loadElements = new JButton("Show selected elements...");
        this.loadElements.setEnabled(false);
        this.loadElements.addActionListener(e -> this.fireNewDataArrived());
        jPanel.add(this.loadElements);
        return jPanel;
    }

    private void fireNewDataArrived() {
        MadxElementType selectedItem = (MadxElementType)this.filterSelection.getSelectedItem();
        LoadElementsTask task = new LoadElementsTask(new MutableSequnceFilter(selectedItem));
        this.asyncExecutor.submitAsync(task);
    }

    public void setAsyncExecutor(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public void setjMadModelManager(JMadModelManager jMadModelManager) {
        this.jMadModelManager = jMadModelManager;
    }

    private class MutableSequnceFilter
    implements SequenceElementFilter {
        private final MadxElementType elementType;

        private MutableSequnceFilter(MadxElementType elementType) {
            this.elementType = elementType;
        }

        public boolean accepts(Element element) {
            if (MadxElementType.KICKER.equals((Object)this.elementType) && (element.getMadxElementType().equals((Object)MadxElementType.HKICKER) || element.getMadxElementType().equals((Object)MadxElementType.VKICKER))) {
                return true;
            }
            return element.getMadxElementType().equals((Object)this.elementType);
        }
    }

    private class LoadElementsTask
    implements Runnable {
        private final SequenceElementFilter filter;

        private LoadElementsTask(SequenceElementFilter filter) {
            this.filter = filter;
        }

        @Override
        public void run() {
            ComparisonPanel.this.elementCellRenderer.setElements(ComparisonPanel.this.jMadModelManager.getCommonSequenceElements(ComparisonPanel.this.model1, ComparisonPanel.this.model2, this.filter));
            ComparisonPanel.this.sequenceElementesModel1.updateElements(JMadModelSeqElementOnNameComparator.getFilteredElements((List)ComparisonPanel.this.model1.getActiveRange().getElements(), (SequenceElementFilter)this.filter));
            ComparisonPanel.this.sequenceElementesModel1.setModelName(ComparisonPanel.this.model1.getName());
            ComparisonPanel.this.sequenceElementesModel2.updateElements(JMadModelSeqElementOnNameComparator.getFilteredElements((List)ComparisonPanel.this.model2.getActiveRange().getElements(), (SequenceElementFilter)this.filter));
            ComparisonPanel.this.sequenceElementesModel2.setModelName(ComparisonPanel.this.model2.getName());
        }
    }
}

