/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.actions;

import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.gui.actions.JMadGuiActions;
import cern.accsoft.steering.jmad.gui.actions.event.SaveTwissEvent;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.OpticUtil;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class SaveTwissEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveTwissEventListener.class);
    private JMadGuiActions jmadGuiActions;
    private JMadModelManager modelManager;
    private JMadModelManagerListener modelManagerListener = new JMadModelManagerAdapter(){

        public void changedActiveModel(JMadModel model) {
            SaveTwissEventListener.this.updateEnabled(model);
        }
    };

    public void init() {
        Preconditions.checkState((this.modelManager != null ? 1 : 0) != 0, (Object)"The model manager must not be null. Most probably a configuration error.");
        this.modelManager.addListener(this.modelManagerListener);
        this.updateEnabled(this.modelManager.getActiveModel());
    }

    @EventListener(value={SaveTwissEvent.class})
    public void saveTwissEventListener() {
        SwingUtilities.invokeLater(this::saveTwiss);
    }

    private void saveTwiss() {
        JMadModel activeModel = this.modelManager.getActiveModel();
        this.checkNonNullActiveModel(activeModel);
        Optional<File> file = this.askUserForTargetFile();
        if (file.isPresent()) {
            this.saveActualTwissToFile(activeModel, file.get());
        } else {
            LOGGER.info("No file selected by user. Nothing saved.");
        }
    }

    private Optional<File> askUserForTargetFile() {
        JFileChooser fileChooser = this.createFileChooser();
        int returnValue = fileChooser.showSaveDialog(null);
        if (0 == returnValue) {
            return Optional.of(fileChooser.getSelectedFile());
        }
        return Optional.empty();
    }

    private JFileChooser createFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Madx Twiss files";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".tfs");
            }
        });
        return fileChooser;
    }

    private void saveActualTwissToFile(JMadModel model, File file) {
        try {
            model.twissToFile(OpticUtil.fullOpticsRequest(), file);
        }
        catch (JMadModelException e) {
            LOGGER.error("Could not write twiss of model '" + model + "'to file '" + file + "'", (Throwable)e);
        }
    }

    private void checkNonNullActiveModel(JMadModel activeModel) {
        if (activeModel == null) {
            throw new IllegalStateException("There is no active model. No TFS can be exported.");
        }
    }

    private void updateEnabled(JMadModel model) {
        this.jmadGuiActions.getSaveTwissAction().setEnabled(model != null);
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public void setJmadGuiActions(JMadGuiActions jmadGuiActions) {
        this.jmadGuiActions = jmadGuiActions;
    }
}

