/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui;

import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.domain.machine.Range;
import cern.accsoft.steering.jmad.gui.actions.event.ChooseOpticsEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ChooseRangeEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CloseActiveModelEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CreateModelFromFileEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CreateModelFromRepositoryEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CreateModelFromUriEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ExitEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ExportModelEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ExportModelUriEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ShowAboutBoxEvent;
import cern.accsoft.steering.jmad.gui.dialog.AboutDialog;
import cern.accsoft.steering.jmad.gui.dialog.JMadOptionPane;
import cern.accsoft.steering.jmad.gui.executor.AsyncExecutor;
import cern.accsoft.steering.jmad.gui.icons.Icon;
import cern.accsoft.steering.jmad.gui.manage.JMadGuiPreferences;
import cern.accsoft.steering.jmad.gui.panels.GuiLogPanel;
import cern.accsoft.steering.jmad.gui.panels.ModelOpticsSelectionPanel;
import cern.accsoft.steering.jmad.gui.panels.RangeSelectionPanel;
import cern.accsoft.steering.jmad.model.AbstractJMadModelListener;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelListener;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.jmad.service.JMadService;
import cern.accsoft.steering.util.gui.UserInteractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jmad.modelpack.gui.conf.JMadModelSelectionDialogFactory;
import org.jmad.modelpack.service.JMadModelPackageService;
import org.jmad.modelpack.util.ModelUris;
import org.ossgang.commons.observables.SubscriptionOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class JMadGui
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JMadGui.class);
    private static final String TITLE_BASE = "JMad ";
    private static final int DEFAULT_WIDTH = 1024;
    private static final int DEFAULT_HEIGHT = 768;
    private final JMadGuiPreferences jmadGuiPreferences;
    private AsyncExecutor asyncExecutor;
    private JMadService jMadService;
    private JMadModelSelectionDialogFactory jMadModelSelectionDialogFactory;
    private JMadModelPackageService jMadModelPackageService;
    private JMadModelManager modelManager;
    private UserInteractor userInteractor;
    private RangeSelectionPanel rangeSelectionPanel;
    private ModelOpticsSelectionPanel modelOpticsSelectionPanel;
    private JPanel mainPanel;
    private JMenuBar jmadMenuBar;
    private JToolBar toolBar;
    private GuiLogPanel guiLogPanel;

    public JMadGui(JMadGuiPreferences jmadGuiPreferences) {
        this.jmadGuiPreferences = jmadGuiPreferences;
    }

    public final void init() {
        Objects.requireNonNull(this.mainPanel, "mainPanel cannot be null. Configuration problem");
        this.setupFramePreferences();
        this.setLayout(new BorderLayout());
        this.setIconImage(Icon.JMAD.getImageIcon().getImage());
        this.setContentPane(this.mainPanel);
        if (this.jmadMenuBar != null) {
            this.setJMenuBar(this.jmadMenuBar);
        }
        if (this.toolBar != null) {
            this.add((Component)this.toolBar, "First");
        }
        if (this.guiLogPanel != null) {
            this.add((Component)this.guiLogPanel, "Last");
        }
        this.setPreferredSize(new Dimension(1024, 768));
    }

    @Override
    public void validate() {
        super.validate();
        this.setPreferredSize(this.getSize());
    }

    public void showGui() {
        SwingUtilities.invokeLater(() -> {
            this.pack();
            this.setVisible(true);
        });
    }

    private void setupFramePreferences() {
        this.jmadGuiPreferences.exitOnCloseProperty().subscribe(close -> SwingUtilities.invokeLater(() -> this.setFrameCloseOperation((boolean)close)), new SubscriptionOption[0]);
        this.setFrameCloseOperation(this.jmadGuiPreferences.isExitOnClose());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (JMadGui.this.jmadGuiPreferences.isCleanupOnClose()) {
                    JMadGui.this.cleanup();
                }
                if (JMadGui.this.jmadGuiPreferences.isExitOnClose()) {
                    System.exit(0);
                }
            }
        });
    }

    private void cleanup() {
        JMadModel model;
        if (this.modelManager != null && (model = this.modelManager.getActiveModel()) != null) {
            try {
                model.cleanup();
            }
            catch (JMadModelException e) {
                LOGGER.error("Error while cleaning up model", (Throwable)e);
            }
        }
    }

    private void updateTitleAccordingTo(JMadModel model) {
        if (model != null) {
            model.addListener((JMadModelListener)new AbstractJMadModelListener(){

                public void opticsDefinitionChanged() {
                    JMadGui.this.updateTitle();
                }

                public void rangeChanged(Range newRange) {
                    JMadGui.this.updateTitle();
                }
            });
        }
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.modelManager == null) {
            return;
        }
        JMadModel model = this.modelManager.getActiveModel();
        if (model == null) {
            this.setTitle(TITLE_BASE);
        } else {
            this.setTitle(TITLE_BASE + model.getDescription());
        }
    }

    private void showExportModelDefinitionDialog() {
        JMadModel model = this.modelManager.getActiveModel();
        if (model == null) {
            LOGGER.warn("No active model to export!");
            return;
        }
        JMadOptionPane.showExportModelDefinitionDialog(this, model.getModelDefinition(), this.jMadService);
    }

    private void showExportModelUriDialog() {
        JMadModel model = this.modelManager.getActiveModel();
        if (model == null) {
            LOGGER.warn("No active model to export!");
            return;
        }
        try {
            String modelUri = ModelUris.modelUri((JMadModel)model).toASCIIString();
            LOGGER.info("Model URI: {}", (Object)modelUri);
            JOptionPane.showMessageDialog(this, new JTextField(modelUri));
        }
        catch (Exception e) {
            LOGGER.error("Error getting model URI: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void showRangeDefinitionChooseDialog() {
        this.userInteractor.showPanelDialog(this.rangeSelectionPanel, (Component)this);
    }

    private void showOpticsDefinitionChooseDialog() {
        this.userInteractor.showPanelDialog(this.modelOpticsSelectionPanel, (Component)this);
    }

    private void showCreateModelFromRepositoryDialog() {
        this.initializeModel(JMadOptionPane.showCreateModelDialog(this.jMadModelSelectionDialogFactory, this.jMadService));
    }

    private void showCreateModelFromFileDialog() {
        this.initializeModel(JMadOptionPane.showCreateModelFromFileDialog(this, this.jMadService));
    }

    private void showCreateModelFromUriDialog() {
        this.initializeModel(JMadOptionPane.showCreateModelFromUriDialog(this, this.jMadModelPackageService));
    }

    private void initializeModel(JMadModel model) {
        if (model == null) {
            return;
        }
        this.asyncExecutor.submitAsync("Initializing model '" + model.getName() + "'", () -> {
            LOGGER.info("Starting Initialization of model '{}'", (Object)model.getName());
            try {
                model.reset();
                LOGGER.info("Initialization of model '{}' finished.", (Object)model.getName());
            }
            catch (JMadModelException e) {
                LOGGER.error("Error while initializing Model '{}'.", (Object)model.getName(), (Object)e);
            }
        });
    }

    @EventListener(value={CreateModelFromRepositoryEvent.class})
    public void createModelFromRepositoryEventListener() {
        SwingUtilities.invokeLater(this::showCreateModelFromRepositoryDialog);
    }

    @EventListener(value={CreateModelFromUriEvent.class})
    public void createModelFromUriEventListener() {
        SwingUtilities.invokeLater(this::showCreateModelFromUriDialog);
    }

    @EventListener(value={CreateModelFromFileEvent.class})
    public void createModelFromFileEventListener() {
        SwingUtilities.invokeLater(this::showCreateModelFromFileDialog);
    }

    @EventListener(value={ExportModelEvent.class})
    public void exportModelEventListener() {
        SwingUtilities.invokeLater(this::showExportModelDefinitionDialog);
    }

    @EventListener(value={ExportModelUriEvent.class})
    public void exportModelUriEventListener() {
        SwingUtilities.invokeLater(this::showExportModelUriDialog);
    }

    @EventListener(value={CloseActiveModelEvent.class})
    public void closeActiveModelEventListener() {
        SwingUtilities.invokeLater(this::closeActiveModel);
    }

    @EventListener(value={ExitEvent.class})
    public void exitEventListener() {
        if (this.jmadGuiPreferences.isExitOnClose()) {
            SwingUtilities.invokeLater(this::exitJMad);
        } else {
            SwingUtilities.invokeLater(() -> this.setVisible(false));
        }
    }

    @EventListener(value={ChooseRangeEvent.class})
    public void chooseRangeEventListener() {
        SwingUtilities.invokeLater(this::showRangeDefinitionChooseDialog);
    }

    @EventListener(value={ChooseOpticsEvent.class})
    public void chooseOpticsEventListener() {
        SwingUtilities.invokeLater(this::showOpticsDefinitionChooseDialog);
    }

    @EventListener(value={ShowAboutBoxEvent.class})
    public void showAboutInfoEventListener() {
        SwingUtilities.invokeLater(this::showAboutBox);
    }

    private void setFrameCloseOperation(boolean close) {
        this.setDefaultCloseOperation(close ? 3 : 1);
    }

    private void exitJMad() {
        this.modelManager.cleanup();
        System.exit(0);
    }

    private void closeActiveModel() {
        JMadModel model = this.modelManager.getActiveModel();
        if (model == null) {
            return;
        }
        try {
            model.cleanup();
        }
        catch (JMadModelException e) {
            LOGGER.error("Error while cleaning up model.", (Throwable)e);
        }
        this.modelManager.removeModel(model);
    }

    private void showAboutBox() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setIcon(Icon.SPLASH.getImageIcon());
        aboutDialog.setText("JMad GUI", "cern-accsoft-steering-jmad-gui", "(C) Copyright CERN 2008-2020  Kajetan Fuchsberger<br>and the BE-OP-LHC software team.");
        aboutDialog.show();
    }

    public void setRangeSelectionPanel(RangeSelectionPanel rangeSelectionPanel) {
        this.rangeSelectionPanel = rangeSelectionPanel;
    }

    public void setModelOpticsSelectionPanel(ModelOpticsSelectionPanel modelOpticsSelectionPanel) {
        this.modelOpticsSelectionPanel = modelOpticsSelectionPanel;
    }

    public void setUserInteractor(UserInteractor userInteractor) {
        this.userInteractor = userInteractor;
    }

    public void setJMadService(JMadService jMadService) {
        this.jMadService = jMadService;
    }

    public void setJMadModelSelectionDialogFactory(JMadModelSelectionDialogFactory jMadModelSelectionDialogFactory) {
        this.jMadModelSelectionDialogFactory = jMadModelSelectionDialogFactory;
    }

    public void setjMadModelPackageService(JMadModelPackageService jMadModelPackageService) {
        this.jMadModelPackageService = jMadModelPackageService;
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        this.modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newModel) {
                JMadGui.this.updateTitleAccordingTo(newModel);
            }
        });
        if (modelManager.getActiveModel() != null) {
            this.updateTitleAccordingTo(modelManager.getActiveModel());
        }
    }

    public JMadGuiPreferences getJmadGuiPreferences() {
        return this.jmadGuiPreferences;
    }

    public void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    public void setJMadMenuBar(JMenuBar menuBar) {
        this.jmadMenuBar = menuBar;
    }

    public void setJMadToolBar(JToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void setGuiLogPanel(GuiLogPanel guiLogPanel) {
        this.guiLogPanel = guiLogPanel;
    }

    public void setAsyncExecutor(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }
}

