/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import cern.accsoft.steering.util.gui.dv.ds.AbstractJmadDataSet;
import cern.accsoft.steering.util.gui.dv.ds.ErrorDataSet;
import java.util.ArrayList;
import java.util.List;

public class ListDataSet
extends AbstractJmadDataSet
implements ErrorDataSet {
    private List<Double> yValues = new ArrayList<Double>();
    private List<Double> yErrorValues = null;
    private List<Boolean> validityValues = null;

    public ListDataSet(String name) {
        super(name);
        this.setUndefValue(Double.NaN);
    }

    public int getDataCount() {
        return this.yValues.size();
    }

    public double getY(int index) {
        return this.yValues.get(index);
    }

    public List<Double> getYValues() {
        return this.yValues;
    }

    public void setValues(List<Double> xValues, List<Double> yValues) {
        this.setXValues(xValues);
        this.yValues = yValues;
        this.fireFullChange();
    }

    public void setValues(List<Double> xValues, List<Double> yValues, List<Boolean> validityValues) {
        this.setXValues(xValues);
        this.yValues = yValues;
        this.validityValues = validityValues;
        this.fireFullChange();
    }

    public void setValues(List<Double> xValues, List<Double> yValues, List<Double> yErrorValues, List<Boolean> validityValues) {
        this.setXValues(xValues);
        this.yValues = yValues;
        this.yErrorValues = yErrorValues;
        this.validityValues = validityValues;
        this.fireFullChange();
    }

    public void setYValues(List<Double> yValues) {
        this.yValues = yValues;
        this.fireFullChange();
    }

    @Override
    public boolean getValidity(int index) {
        if (this.getValidityValues() == null) {
            return true;
        }
        return this.getValidityValues().get(index);
    }

    private List<Boolean> getValidityValues() {
        return this.validityValues;
    }

    @Override
    public boolean hasValidityInformation() {
        return this.validityValues != null;
    }

    public List<Double> getYErrorValues() {
        return this.yErrorValues;
    }

    @Override
    public Double getYError(int index) {
        if (this.yErrorValues != null && index < this.yErrorValues.size()) {
            return this.yErrorValues.get(index);
        }
        return null;
    }
}

