/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels.var;

import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.domain.var.custom.CustomVariable;
import cern.accsoft.steering.jmad.gui.panels.var.AbstractVarSelectionTableModel;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.jmad.model.manage.StrengthVarManagerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CustomVarSelectionTableModel
extends AbstractVarSelectionTableModel {
    private static final long serialVersionUID = 1630862227442352343L;
    private JMadModelManager modelManager;
    private int columnCount;
    private static final int COL_NAME = 0;
    private static final int COL_EXPRESSION = 1;
    private static final int COL_COMMENT = 2;
    private List<CustomVariable> variables;
    StrengthVarManagerListener strengthVarListener;

    public CustomVarSelectionTableModel() {
        this.updateColumnCounts();
        this.variables = new ArrayList<CustomVariable>();
        this.strengthVarListener = new StrengthVarManagerListener(){

            public void changedData() {
                JMadModel model = CustomVarSelectionTableModel.this.modelManager.getActiveModel();
                if (model != null) {
                    CustomVarSelectionTableModel.this.variables = model.getStrengthsAndVars().getVariables();
                } else {
                    CustomVarSelectionTableModel.this.variables = Collections.emptyList();
                }
                CustomVarSelectionTableModel.this.fireTableDataChanged();
            }
        };
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.variables.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        CustomVariable variable = this.variables.get(row);
        switch (col - this.axesCount) {
            case -1: {
                return this.getSelectedVarManager().getSelectedVariables().contains(variable);
            }
            case 0: {
                return variable.getMadxName();
            }
            case 1: {
                return variable.getExpression();
            }
            case 2: {
                return variable.getComment();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col - this.axesCount) {
            case -1: {
                return Boolean.class;
            }
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        switch (col - this.axesCount) {
            case -1: {
                return "plot";
            }
            case 0: {
                return "variable";
            }
            case 1: {
                return "expression";
            }
            case 2: {
                return "comment";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.axesCount > 0 && col == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        CustomVariable variable = this.variables.get(row);
        switch (col - this.axesCount) {
            case -1: {
                if (((Boolean)value).booleanValue()) {
                    this.getSelectedVarManager().add((TwissVariable)variable);
                } else {
                    this.getSelectedVarManager().remove((TwissVariable)variable);
                }
                this.fireTableDataChanged();
            }
        }
    }

    @Override
    public List<? extends TwissVariable> getAvailableVariables() {
        return this.variables;
    }

    @Override
    protected void updateColumnCounts() {
        this.columnCount = this.axesCount + 3;
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newActiveModel) {
                if (newActiveModel == null) {
                    return;
                }
                newActiveModel.getStrengthVarManager().addListener(CustomVarSelectionTableModel.this.strengthVarListener);
            }
        });
    }
}

