/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.ModelMode;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ModelOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JMadModelManager modelManager;
    private JComboBox cboMode;
    private ActionListener cboListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadModel model = ModelOptionsPanel.this.getModelManager().getActiveModel();
            ModelMode mode = (ModelMode)ModelOptionsPanel.this.cboMode.getSelectedItem();
            if (model != null && mode != null) {
                model.setMode(mode);
            }
        }
    };
    private JMadModelManagerListener modelManagerListener = new JMadModelManagerAdapter(){

        public void changedActiveModel(JMadModel newActiveModel) {
            ModelOptionsPanel.this.setModel(newActiveModel);
        }
    };

    public void init() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.cboMode = new JComboBox<ModelMode>(ModelMode.values());
        this.setModel(this.getModelManager().getActiveModel());
        this.cboMode.addActionListener(this.cboListener);
        this.add((Component)this.cboMode, constraints);
    }

    private void setModel(JMadModel model) {
        if (model != null) {
            this.cboMode.setSelectedItem(model.getMode());
        }
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        this.modelManager.addListener(this.modelManagerListener);
    }

    private JMadModelManager getModelManager() {
        return this.modelManager;
    }
}

