/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.gui.components.DoubleTableCellRenderer;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.jmad.modeldefs.domain.OpticsDefinition;
import cern.accsoft.steering.util.gui.menu.MousePopupListener;
import cern.accsoft.steering.util.gui.menu.TablePopupMenu;
import cern.accsoft.steering.util.gui.panels.Applyable;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import cern.accsoft.steering.util.gui.panels.Titleable;
import cern.accsoft.steering.util.gui.table.SelectionSetTableModel;
import cern.accsoft.steering.util.gui.table.TableModelSelectionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelOpticsSelectionPanel
extends JPanel
implements Titleable,
Applyable {
    private static final long serialVersionUID = 1733380183463632497L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelOpticsSelectionPanel.class);
    private ModelOpticsDefinitionTableModel tableModel;
    private JMadModel model;
    private TableModelSelectionAdapter selectionAdapter;

    public ModelOpticsSelectionPanel() {
        super(new BorderLayout());
    }

    public void init() {
        this.initComponents();
        if (this.model != null) {
            this.refreshDisplay();
        }
    }

    public void setModelManager(JMadModelManager modelManager) {
        modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newModel) {
                ModelOpticsSelectionPanel.this.setModel(newModel);
                ModelOpticsSelectionPanel.this.refreshDisplay();
            }
        });
        if (modelManager.getActiveModel() != null) {
            this.setModel(modelManager.getActiveModel());
        }
    }

    protected void refreshDisplay() {
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
    }

    private void initComponents() {
        this.tableModel = new ModelOpticsDefinitionTableModel();
        JTable table = new JTable(this.tableModel);
        table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        table.setAutoCreateRowSorter(true);
        table.getSelectionModel().setSelectionMode(1);
        new MousePopupListener(table, new TablePopupMenu(this.tableModel));
        this.selectionAdapter = new TableModelSelectionAdapter(table);
        this.tableModel.setTableModelSelectionAdapter(this.selectionAdapter);
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        this.add((Component)new TableFilterPanel(table), "North");
        this.add((Component)scrollPane, "Center");
    }

    private void setSelectedOpticsDefinition() {
        int row = this.selectionAdapter.getSelectedRowIndex();
        OpticsDefinition opticsDefinition = this.getOpticsDefinitions().get(row);
        try {
            this.getModel().setActiveOpticsDefinition(opticsDefinition);
        }
        catch (JMadModelException e) {
            LOGGER.error("Could not set Optic [" + opticsDefinition.getName() + "] in Model [" + this.getModel() + "].");
        }
    }

    private void setModel(JMadModel model) {
        this.model = model;
    }

    private List<OpticsDefinition> getOpticsDefinitions() {
        if (this.getModel() != null) {
            return this.getModel().getModelDefinition().getOpticsDefinitions();
        }
        return new ArrayList<OpticsDefinition>();
    }

    private JMadModel getModel() {
        return this.model;
    }

    public SelectionSetTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public String getTitle() {
        return "Optics selection";
    }

    @Override
    public boolean apply() {
        this.setSelectedOpticsDefinition();
        return true;
    }

    @Override
    public void cancel() {
    }

    class ModelOpticsDefinitionTableModel
    extends SelectionSetTableModel {
        private static final int COLUMN_COUNT = 1;
        private static final int COL_NAME = 0;
        private static final long serialVersionUID = 1L;

        ModelOpticsDefinitionTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            List opticsDefinitions = ModelOpticsSelectionPanel.this.getOpticsDefinitions();
            if (opticsDefinitions != null) {
                return opticsDefinitions.size();
            }
            return 0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            List opticsDefinitions = ModelOpticsSelectionPanel.this.getOpticsDefinitions();
            if (opticsDefinitions == null) {
                return null;
            }
            OpticsDefinition opticsDefinition = (OpticsDefinition)opticsDefinitions.get(row);
            switch (col) {
                case 0: {
                    return opticsDefinition.getName();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "optics name";
                }
            }
            return null;
        }
    }
}

