/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.result.tfs.TfsResult;
import cern.accsoft.steering.jmad.gui.actions.JMadGuiActions;
import cern.accsoft.steering.jmad.gui.data.TfsResultDataSet;
import cern.accsoft.steering.jmad.gui.dv.ChartFactory;
import cern.accsoft.steering.jmad.gui.icons.Icon;
import cern.accsoft.steering.jmad.gui.manage.DataSetManagerListener;
import cern.accsoft.steering.jmad.gui.manage.TfsDataSetManager;
import cern.accsoft.steering.jmad.gui.panels.PlotCreationPanel;
import cern.accsoft.steering.util.gui.UserInteractor;
import cern.jdve.Chart;
import cern.jdve.ChartRenderer;
import cern.jdve.Style;
import cern.jdve.data.DataSet;
import cern.jdve.data.DataSource;
import cern.jdve.data.DefaultDataSource;
import cern.jdve.renderer.StairsChartRenderer;
import cern.jdve.viewer.DVView;
import cern.jdve.viewer.DataView;
import cern.jdve.viewer.DataViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DataViewerPanel
extends JPanel
implements DataSetManagerListener {
    private static final Dimension PREFERRED_SIZE_DV = new Dimension(800, 300);
    private static final long serialVersionUID = 1L;
    private DataViewer dataViewer = null;
    private TfsDataSetManager tfsDataSetManager = null;
    private ChartFactory chartFactory;
    private PlotCreationPanel plotCreationPanel;
    private UserInteractor userInteractor;
    private JMadGuiActions jmadGuiActions;
    private final Action createPlotAction = new AbstractAction("Add view"){
        private static final long serialVersionUID = 1L;
        {
            DataViewerPanel.this.setToolTipText("Create a new chart-view.");
            this.putValue("SmallIcon", Icon.CHART.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DataViewerPanel.this.getUserInteractor().showPanelDialog(DataViewerPanel.this.getPlotCreationPanel(), (Component)DataViewerPanel.this);
        }
    };

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.dataViewer = new DataViewer();
        this.dataViewer.setExplorerVisible(true);
        this.add((Component)this.dataViewer, "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.add((Component)buttonPanel, "South");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        JButton btn = new JButton(this.createPlotAction);
        buttonPanel.add((Component)btn, constraints);
        btn = new JButton(new AbstractAction("Refresh all views"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataViewerPanel.this.tfsDataSetManager != null) {
                    DataViewerPanel.this.tfsDataSetManager.refresh();
                }
            }
        });
        constraints.weightx = 1.0;
        ++constraints.gridx;
        buttonPanel.add((Component)btn, constraints);
        btn = new JButton(new AbstractAction(" >>> ref "){
            private static final long serialVersionUID = 9180066463817578987L;
            {
                this.putValue("ShortDescription", "Stores the actual available data as reference for relative charts.");
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataViewerPanel.this.getTfsDataSetManager().setAsReference();
            }
        });
        constraints.weightx = 0.0;
        ++constraints.gridx;
        buttonPanel.add((Component)btn, constraints);
        JButton saveTwissButton = new JButton(this.jmadGuiActions.getSaveTwissAction());
        constraints.weightx = 0.0;
        ++constraints.gridx;
        buttonPanel.add((Component)saveTwissButton, constraints);
    }

    private void createChart(String name, String xLabel, Map<Integer, List<TfsResultDataSet>> dataSets) {
        if (this.getChartFactory() == null) {
            return;
        }
        Chart chart = null;
        int axisCount = 0;
        for (Integer yAxis : dataSets.keySet()) {
            ArrayList<TfsResultDataSet> aperDataSets = new ArrayList<TfsResultDataSet>();
            DefaultDataSource dataSource = new DefaultDataSource();
            for (TfsResultDataSet dataSet : dataSets.get(yAxis)) {
                if (dataSet.isApertureDataSet()) {
                    aperDataSets.add(dataSet);
                    continue;
                }
                dataSource.addDataSet((DataSet)dataSet);
            }
            String yAxisTitle = "Y" + new Integer(yAxis + 1).toString();
            if (chart == null) {
                chart = this.getChartFactory().createMarkablePolyLineChart((DataSource)dataSource);
                chart.setName(name);
                chart.getXScale().setTitle(xLabel);
                chart.getYScale().setTitle(yAxisTitle);
            } else {
                chart.addYAxis(true, false);
                chart.getYScale(axisCount).setTitle(yAxisTitle);
                chart.getYScale(axisCount).synchronizeWith(chart.getYScale(), true);
                chart.addRenderer(axisCount, (ChartRenderer)this.getChartFactory().createPolyLineRenderer((DataSource)dataSource));
            }
            if (aperDataSets.size() > 0) {
                DefaultDataSource aperDataSource = new DefaultDataSource(aperDataSets.toArray(new DataSet[aperDataSets.size()]));
                StairsChartRenderer renderer = new StairsChartRenderer();
                renderer.setDataSource((DataSource)aperDataSource);
                Style[] styles = new Style[aperDataSets.size()];
                for (int i = 0; i < aperDataSets.size(); ++i) {
                    styles[i] = new Style(Color.black);
                }
                renderer.setStyles(styles);
                chart.addRenderer(axisCount, (ChartRenderer)renderer);
            }
            ++axisCount;
        }
        DVView dvView = new DVView(name);
        dvView.addDataView(new DataView(chart));
        this.dataViewer.addView(dvView);
        this.dataViewer.setCurrentView(dvView);
    }

    public void setTfsDataSetManager(TfsDataSetManager tfsDataSetManager) {
        this.tfsDataSetManager = tfsDataSetManager;
        tfsDataSetManager.addListener(this);
    }

    public TfsDataSetManager getTfsDataSetManager() {
        return this.tfsDataSetManager;
    }

    public void setChartFactory(ChartFactory chartFactory) {
        this.chartFactory = chartFactory;
    }

    private ChartFactory getChartFactory() {
        return this.chartFactory;
    }

    @Override
    public void createdDataSets(String name, String xLabel, Map<Integer, List<TfsResultDataSet>> dataSets) {
        this.createChart(name, xLabel, dataSets);
    }

    public void setPlotCreationPanel(PlotCreationPanel plotCreationPanel) {
        this.plotCreationPanel = plotCreationPanel;
    }

    private PlotCreationPanel getPlotCreationPanel() {
        return this.plotCreationPanel;
    }

    public void setUserInteractor(UserInteractor userInteractor) {
        this.userInteractor = userInteractor;
    }

    private UserInteractor getUserInteractor() {
        return this.userInteractor;
    }

    @Override
    public void twissCalculated(TfsResult tfsResult) {
    }

    public void setJmadGuiActions(JMadGuiActions jmadGuiActions) {
        this.jmadGuiActions = jmadGuiActions;
    }
}

