/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.gui.manage.CustomFileManager;
import cern.accsoft.steering.jmad.gui.manage.CustomFileManagerListener;
import cern.accsoft.steering.jmad.gui.manage.JMadGuiPreferences;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Lookup;

public class CustomFileManagerPanel
extends JPanel {
    private static final long serialVersionUID = 1427999923260387841L;
    private static final Logger logger = LoggerFactory.getLogger(CustomFileManagerPanel.class);
    private static final Dimension PREFERRED_TABLE_SIZE = new Dimension(200, 200);
    private CustomFilesTableModel tableModel = new CustomFilesTableModel();
    private CustomFileManager customFileManager;
    private JMadModelManager modelManager;
    private boolean parseWhenRunning = true;
    private FileFilter madxFileFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String lowername = f.getName().toLowerCase();
            if (lowername.endsWith(".str")) {
                return true;
            }
            if (lowername.endsWith(".madx")) {
                return true;
            }
            return lowername.endsWith(".seq");
        }

        @Override
        public String getDescription() {
            return "MADX - files";
        }
    };

    public CustomFileManagerPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JTable table = new JTable(this.tableModel);
        table.setAutoCreateRowSorter(true);
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getSource() == table.getSelectionModel() && (index = table.getSelectedRow()) >= 0) {
                    CustomFileManagerPanel.this.tableModel.setCurrentElement(table.convertRowIndexToModel(index));
                }
            }
        });
        this.add((Component)new TableFilterPanel(table), "North");
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        scrollPane.setPreferredSize(PREFERRED_TABLE_SIZE);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.createButtonsPanel(), "South");
        this.validate();
    }

    private JPanel createButtonsPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        JButton btn = new JButton(this.createLoadFileAction());
        buttonPanel.add((Component)btn, constraints);
        ++constraints.gridx;
        btn = new JButton(this.createEditAction());
        buttonPanel.add((Component)btn, constraints);
        ++constraints.gridx;
        btn = new JButton(this.createRunAction());
        buttonPanel.add((Component)btn, constraints);
        ++constraints.gridx;
        final JCheckBox chk = new JCheckBox("parse when run");
        chk.setSelected(this.parseWhenRunning);
        chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomFileManagerPanel.this.parseWhenRunning = chk.isSelected();
            }
        });
        buttonPanel.add((Component)chk, constraints);
        return buttonPanel;
    }

    private Action createEditAction() {
        AbstractAction action = new AbstractAction("edit"){
            private static final long serialVersionUID = 1569348877859639865L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                File selectedFile = CustomFileManagerPanel.this.tableModel.getSelecFile();
                if (selectedFile == null) {
                    logger.warn("No file selected. Nothing to do.");
                    return;
                }
                String editorCommand = CustomFileManagerPanel.this.getEditorCommand();
                if (editorCommand == null) {
                    logger.warn("No editor configured! Cannot open the file to edit.");
                    return;
                }
                String[] cmdArray = new String[]{editorCommand, selectedFile.getAbsolutePath()};
                try {
                    Runtime.getRuntime().exec(cmdArray);
                }
                catch (IOException e) {
                    logger.error("error executing command-array: " + cmdArray.toString(), (Throwable)e);
                }
            }
        };
        action.putValue("ShortDescription", "Opens the file in editor.");
        return action;
    }

    private Action createRunAction() {
        AbstractAction action = new AbstractAction("run"){
            private static final long serialVersionUID = -320576052275084112L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                File selectedFile = CustomFileManagerPanel.this.tableModel.getSelecFile();
                if (selectedFile == null) {
                    logger.warn("No file selected. Nothing to do.");
                    return;
                }
                JMadModel model = CustomFileManagerPanel.this.getActiveModel();
                if (model == null) {
                    logger.warn("No active model. Cannot run file.");
                    return;
                }
                model.call(selectedFile);
                if (CustomFileManagerPanel.this.parseWhenRunning) {
                    model.getStrengthVarManager().load(selectedFile);
                }
            }
        };
        action.putValue("ShortDescription", "runs the selected file within the current model.");
        return action;
    }

    private void addFile() {
        int returnValue;
        if (this.getCustomFileManager() == null) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(this.madxFileFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter(this.madxFileFileFilter);
        String workingDir = this.getWorkingDir();
        if (workingDir != null) {
            fileChooser.setCurrentDirectory(new File(workingDir));
        }
        if ((returnValue = fileChooser.showOpenDialog(this)) == 0) {
            File file = fileChooser.getSelectedFile();
            this.getCustomFileManager().add(file);
        }
    }

    private Action createLoadFileAction() {
        AbstractAction action = new AbstractAction("add file"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomFileManagerPanel.this.addFile();
            }
        };
        action.putValue("ShortDescription", "adds a new file to the list");
        return action;
    }

    public void setCustomFileManager(CustomFileManager customFileManager) {
        this.customFileManager = customFileManager;
        this.customFileManager.addListener(new CustomFileManagerListener(){

            @Override
            public void changedFiles() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomFileManagerPanel.this.tableModel.setFiles(CustomFileManagerPanel.this.customFileManager.getFiles());
                    }
                });
            }
        });
    }

    public CustomFileManager getCustomFileManager() {
        return this.customFileManager;
    }

    @Lookup
    public JMadGuiPreferences getJmadGuiPreferences() {
        return null;
    }

    private String getWorkingDir() {
        return this.getJmadGuiPreferences().getWorkingDir();
    }

    private String getEditorCommand() {
        return this.getJmadGuiPreferences().getEditorCommand();
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public JMadModel getActiveModel() {
        if (this.modelManager == null) {
            return null;
        }
        return this.modelManager.getActiveModel();
    }

    private class CustomFilesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4386551081279607172L;
        private static final int COLUMN_COUNT = 1;
        private static final int COL_NAME = 0;
        private List<File> files = new ArrayList<File>();
        private File selectedFile = null;

        private CustomFilesTableModel() {
        }

        private synchronized void setFiles(List<File> files) {
            this.files = files;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.files.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            File file = this.files.get(row);
            switch (col) {
                case 0: {
                    return file.getAbsoluteFile();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "filename";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            throw new UnsupportedOperationException("Not imlemented");
        }

        private void setCurrentElement(int index) {
            if (CustomFileManagerPanel.this.getCustomFileManager() == null) {
                return;
            }
            if (index >= 0 && index < this.files.size()) {
                this.selectedFile = this.files.get(index);
            }
        }

        private File getSelecFile() {
            return this.selectedFile;
        }
    }
}

