/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.dv;

import cern.accsoft.steering.jmad.gui.mark.MarkedElementsManager;
import cern.accsoft.steering.jmad.gui.mark.MarkedElementsManagerListener;
import cern.accsoft.steering.jmad.gui.mark.MarkerXProvider;
import cern.jdve.Chart;
import cern.jdve.ChartDecoration;
import cern.jdve.LabelRenderer;
import cern.jdve.Style;
import cern.jdve.data.DataSet;
import cern.jdve.data.DataSource;
import cern.jdve.graphic.DataIndicator;
import cern.jdve.utils.DataRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class MarkableChart
extends Chart {
    private static final long serialVersionUID = -6909388067830384883L;
    private MarkedElementsManager markedElementsManager;
    private Map<String, List<DataIndicator>> markerDataIndicators = new HashMap<String, List<DataIndicator>>();
    private MarkerXProvider markerXProvider = null;
    private static final Font DEFAULT_INDICATOR_FONT = new Font("Dialog", 1, 10);
    private static final Style DEFAULT_INDICATOR_STYLE = new Style((Stroke)new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f, 2.0f}, 2.0f), Color.GRAY, Color.BLACK);
    private static final Color COLOR_H_RANGE = new Color(227, 151, 89, 50);
    private static final Color COLOR_V_RANGE = new Color(89, 188, 227, 50);
    private static final Font DEFAULT_FONT_RANGE = new Font("Dialog", 1, 20);
    private boolean visibleHVIndicators = false;
    private DataIndicator hRangeIndicator = null;
    private DataIndicator vRangeIndicator = null;

    public void initMarkers() {
        if (this.getMarkedElementsManager() == null) {
            return;
        }
        for (String elementName : this.getMarkedElementsManager().getElementNames()) {
            this.addMarker(elementName);
        }
    }

    private void addMarker(String elementName) {
        this.removeMarker(elementName);
        List<Double> xPositions = this.getMarkerXPositions(elementName);
        ArrayList<DataIndicator> dataIndicators = new ArrayList<DataIndicator>();
        for (Double xPos : xPositions) {
            DataIndicator indicator = this.createXIndicator(xPos, elementName);
            dataIndicators.add(indicator);
            this.addDecoration((ChartDecoration)indicator);
        }
        this.markerDataIndicators.put(elementName, dataIndicators);
        this.repaintChart();
    }

    private void removeMarker(String elementName) {
        List<DataIndicator> indicators = this.markerDataIndicators.get(elementName);
        if (indicators != null) {
            for (DataIndicator indicator : indicators) {
                this.removeDecoration((ChartDecoration)indicator);
            }
        }
        this.markerDataIndicators.remove(elementName);
        this.repaintChart();
    }

    private void createHVRangeIndicators() {
        this.removeHVRangeIndicators();
        List<Double> xPositions = this.getMarkerXPositions("BORDER_BETWEEN_HORIZONTAL_AND_VERTICAL_PLANE_RANGE");
        Double hvBorder = null;
        if (xPositions.size() != 1) {
            return;
        }
        hvBorder = xPositions.get(0);
        double minX = this.getXAxis().getVisibleRange().getMin();
        double maxX = this.getXAxis().getVisibleRange().getMax();
        this.hRangeIndicator = this.createRangeIndicator(new DataRange(minX, hvBorder.doubleValue()), COLOR_H_RANGE, "H");
        this.addDecoration((ChartDecoration)this.hRangeIndicator);
        this.vRangeIndicator = this.createRangeIndicator(new DataRange(hvBorder.doubleValue(), maxX), COLOR_V_RANGE, "V");
        this.addDecoration((ChartDecoration)this.vRangeIndicator);
        this.repaintChart();
    }

    private DataIndicator createRangeIndicator(DataRange dataRange, Color fillColor, String label) {
        DataIndicator rangeIndicator = new DataIndicator(3, dataRange, label);
        rangeIndicator.setTextLocation(0.8);
        rangeIndicator.setStyle(new Style(fillColor, fillColor));
        LabelRenderer labelRenderer = rangeIndicator.getLabelRenderer();
        labelRenderer.setBackground(null);
        labelRenderer.setForeground(fillColor.darker());
        labelRenderer.setFont(DEFAULT_FONT_RANGE);
        return rangeIndicator;
    }

    private void removeHVRangeIndicators() {
        if (this.hRangeIndicator != null) {
            this.removeDecoration((ChartDecoration)this.hRangeIndicator);
        }
        if (this.vRangeIndicator != null) {
            this.removeDecoration((ChartDecoration)this.vRangeIndicator);
        }
        this.repaintChart();
    }

    private List<Double> getMarkerXPositions(String elementName) {
        List<Double> xPositions = new ArrayList<Double>();
        if (this.getMarkerXProvider() != null) {
            xPositions = this.getMarkerXProvider().getXPositions(elementName);
        }
        if (xPositions.size() > 0) {
            return xPositions;
        }
        DataSource[] dataSources = this.getDataSources();
        for (int i = 0; i < dataSources.length; ++i) {
            DataSet[] dataSets = dataSources[i].getDataSets();
            for (int j = 0; j < dataSets.length; ++j) {
                MarkerXProvider markable;
                List<Double> xPosNew;
                DataSet dataSet = dataSets[j];
                if (!(dataSet instanceof MarkerXProvider) || (xPosNew = (markable = (MarkerXProvider)dataSet).getXPositions(elementName)).size() <= xPositions.size()) continue;
                xPositions = xPosNew;
                return xPositions;
            }
        }
        return xPositions;
    }

    private DataIndicator createXIndicator(double xPos, String label) {
        DataIndicator pointIndicator = new DataIndicator(1, xPos, label);
        pointIndicator.setTextLocation(0.06);
        pointIndicator.setStyle(DEFAULT_INDICATOR_STYLE);
        LabelRenderer labelRenderer = pointIndicator.getLabelRenderer();
        labelRenderer.setHorizontalAlignment(0);
        labelRenderer.setBackground(Color.WHITE);
        labelRenderer.setForeground(Color.DARK_GRAY);
        labelRenderer.setBorder((Border)new LineBorder(Color.DARK_GRAY));
        labelRenderer.setFont(DEFAULT_INDICATOR_FONT);
        return pointIndicator;
    }

    public void setMarkedElementsManager(MarkedElementsManager markedElementsManager) {
        this.markedElementsManager = markedElementsManager;
        markedElementsManager.addListener(new MarkedElementsManagerListener(){

            @Override
            public void addedElementName(String elementName) {
                MarkableChart.this.addMarker(elementName);
            }

            @Override
            public void removedElementName(String elementName) {
                MarkableChart.this.removeMarker(elementName);
            }
        });
    }

    private MarkedElementsManager getMarkedElementsManager() {
        return this.markedElementsManager;
    }

    public void setMarkerXProvider(MarkerXProvider markerXProvider) {
        this.markerXProvider = markerXProvider;
    }

    public MarkerXProvider getMarkerXProvider() {
        return this.markerXProvider;
    }

    public void setVisibleHVIndicators(boolean visibleHVIndicators) {
        this.visibleHVIndicators = visibleHVIndicators;
        if (visibleHVIndicators) {
            this.createHVRangeIndicators();
        } else {
            this.removeHVRangeIndicators();
        }
    }

    public boolean isVisibleHVIndicators() {
        return this.visibleHVIndicators;
    }
}

