/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.dv;

import cern.accsoft.steering.jmad.gui.dv.AccurateCoordinatesPane;
import cern.accsoft.steering.jmad.gui.dv.MarkableChart;
import cern.jdve.Chart;
import cern.jdve.ChartInteractor;
import cern.jdve.ChartRenderer;
import cern.jdve.data.DataSource;
import cern.jdve.graphic.MarkerFactory;
import cern.jdve.interactor.CoordinatesPane;
import cern.jdve.interactor.DataPickerInteractor;
import cern.jdve.interactor.ScrollInteractor;
import cern.jdve.interactor.ZoomInteractor;
import cern.jdve.renderer.PolylineChartRenderer;

public abstract class ChartFactory {
    public Chart createMarkablePolyLineChart(DataSource ds) {
        MarkableChart chart = this.createMarkableChart();
        this.configurePolylineChart(ds, chart);
        chart.initMarkers();
        return chart;
    }

    public void configurePolylineChart(DataSource ds, Chart chart) {
        PolylineChartRenderer renderer = this.createPolyLineRenderer(ds);
        chart.addRenderer((ChartRenderer)renderer);
        chart.setLegendVisible(true);
        chart.addInteractor((ChartInteractor)new ZoomInteractor());
        chart.addInteractor((ChartInteractor)new ScrollInteractor());
        DataPickerInteractor dataPicker = new DataPickerInteractor();
        dataPicker.setPointCoordPane((CoordinatesPane)new AccurateCoordinatesPane());
        dataPicker.setDisplayDataSetName(false);
        dataPicker.setCursorCoordPainted(false);
        dataPicker.getPointCoordPane().setXCoordDisplay(1);
        chart.addInteractor((ChartInteractor)dataPicker);
    }

    public PolylineChartRenderer createPolyLineRenderer(DataSource ds) {
        PolylineChartRenderer renderer = new PolylineChartRenderer(MarkerFactory.getMarker((int)2));
        renderer.setMarkerSize(3);
        renderer.setDataSource(ds);
        return renderer;
    }

    public abstract MarkableChart createMarkableChart();
}

