/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.panels;

import cern.accsoft.steering.jmad.util.ListUtil;
import cern.accsoft.steering.util.gui.script.ScriptConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanShellPanel
extends JPanel
implements ApplicationContextAware {
    private static final long serialVersionUID = 4374231778801633419L;
    private static final String BSH_APPCONTEXT_NAME = "ctx";
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ScriptConsole console = new ScriptConsole();

    public void init() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        List items = ListUtil.map(this.scriptEngineManager.getEngineFactories(), (ListUtil.Mapper)new ListUtil.Mapper<ScriptEngineFactory, ScriptEngineFactoryItem>(){

            public ScriptEngineFactoryItem map(ScriptEngineFactory inobject) {
                return new ScriptEngineFactoryItem(inobject);
            }
        });
        final JComboBox<Object> cboScriptingEngineFactories = new JComboBox<Object>(items.toArray());
        cboScriptingEngineFactories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = cboScriptingEngineFactories.getSelectedItem();
                if (item == null) {
                    return;
                }
                ScriptEngineFactory factory = ((ScriptEngineFactoryItem)item).getFactory();
                BeanShellPanel.this.setScriptEngine(factory);
            }
        });
        if (items.size() > 0) {
            this.setScriptEngine(((ScriptEngineFactoryItem)items.get(0)).getFactory());
        }
        this.add(cboScriptingEngineFactories, "North");
        this.add((Component)this.console, "Center");
    }

    private void setScriptEngine(ScriptEngineFactory factory) {
        String shortName = factory.getNames().get(0);
        ScriptEngine engine = this.scriptEngineManager.getEngineByName(shortName);
        this.console.setScriptEngine(engine);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.scriptEngineManager.put(BSH_APPCONTEXT_NAME, applicationContext);
    }

    public void setContextObjects(Map<String, Object> contextObjects) {
        this.scriptEngineManager.getBindings().putAll((Map<? extends String, ? extends Object>)contextObjects);
    }

    private static class ScriptEngineFactoryItem {
        private ScriptEngineFactory factory;

        private ScriptEngineFactoryItem(ScriptEngineFactory factory) {
            this.factory = factory;
        }

        public String toString() {
            return this.factory.getEngineName();
        }

        public ScriptEngineFactory getFactory() {
            return this.factory;
        }
    }
}

