/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.mark;

import cern.accsoft.steering.jmad.gui.mark.MarkedElementsManager;
import cern.accsoft.steering.jmad.gui.mark.MarkedElementsManagerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MarkedElementsManagerImpl
implements MarkedElementsManager {
    private Set<String> elementNames = new HashSet<String>();
    private List<MarkedElementsManagerListener> listeners = new ArrayList<MarkedElementsManagerListener>();

    @Override
    public void addElementName(String elementName) {
        this.elementNames.add(elementName);
        this.fireAddedElementName(elementName);
    }

    @Override
    public boolean contains(String elementName) {
        return this.elementNames.contains(elementName);
    }

    @Override
    public Collection<String> getElementNames() {
        return this.elementNames;
    }

    @Override
    public void removeElementName(String elementName) {
        this.elementNames.remove(elementName);
        this.fireRemovedElementName(elementName);
    }

    private void fireAddedElementName(String elementName) {
        for (MarkedElementsManagerListener listener : this.listeners) {
            listener.addedElementName(elementName);
        }
    }

    private void fireRemovedElementName(String elementName) {
        for (MarkedElementsManagerListener listener : this.listeners) {
            listener.removedElementName(elementName);
        }
    }

    @Override
    public void addListener(MarkedElementsManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(MarkedElementsManagerListener listener) {
        this.listeners.remove(listener);
    }
}

