/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.actions;

import cern.accsoft.steering.jmad.gui.actions.event.ChooseOpticsEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ChooseRangeEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CloseActiveModelEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CreateModelFromFileEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CreateModelFromRepositoryEvent;
import cern.accsoft.steering.jmad.gui.actions.event.CreateModelFromUriEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ExitEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ExportModelEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ExportModelUriEvent;
import cern.accsoft.steering.jmad.gui.actions.event.SaveTwissEvent;
import cern.accsoft.steering.jmad.gui.actions.event.ShowAboutBoxEvent;
import cern.accsoft.steering.jmad.gui.icons.Icon;
import cern.accsoft.steering.jmad.gui.manage.JMadGuiPreferences;
import cern.accsoft.steering.util.gui.NamedAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.ossgang.commons.observables.SubscriptionOption;
import org.springframework.context.ApplicationEventPublisher;

public final class JMadGuiActions {
    private final ApplicationEventPublisher publisher;
    private final Action createModelAction = new NamedAction("Create Model ...", "Creates a new model ..."){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.NEW.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JComponent) {
                JComponent sourceComponent = (JComponent)source;
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.add(JMadGuiActions.this.createModelFromRepositoryAction);
                popupMenu.add(JMadGuiActions.this.createModelFromUriAction);
                popupMenu.add(JMadGuiActions.this.createModelFromFileAction);
                popupMenu.show(sourceComponent, 0, 0);
            }
        }
    };
    private final Action createModelFromRepositoryAction = new NamedAction("Create Model from Repository", "Creates a new model from the repository."){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.OPEN_REPO.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new CreateModelFromRepositoryEvent());
        }
    };
    private final Action createModelFromFileAction = new NamedAction("Create Model from ZIP File", "Creates a new model from an local ZIP file."){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.OPEN_FILE.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new CreateModelFromFileEvent());
        }
    };
    private final Action createModelFromUriAction = new NamedAction("Create Model from URI", "Creates a new model from a URI."){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.OPEN_URI.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new CreateModelFromUriEvent());
        }
    };
    private final Action exportModelAction = new NamedAction("Export model definition", "Saves the active model definition to a file."){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.EXPORT.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new ExportModelEvent());
        }
    };
    private final Action exportModelUriAction = new NamedAction("Get the active model URI", "Gets an URI of the active model."){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.EXPORT_URI.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new ExportModelUriEvent());
        }
    };
    private final Action closeActiveModelAction = new NamedAction("Close active model", "Closes the active model"){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("SmallIcon", Icon.DELETE.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JMadGuiActions.this.publisher.publishEvent((Object)new CloseActiveModelEvent());
        }
    };
    private final Action exitAction = new AbstractAction("Exit", Icon.EXIT.getImageIcon()){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("ShortDescription", "Exit Application");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new ExitEvent());
        }
    };
    private final Action chooseRangeAction = new NamedAction("select range", "Select one of the possible ranges of the model."){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new ChooseRangeEvent());
        }
    };
    private final Action chooseOpticsAction = new NamedAction("select optics", "Select optics definition of the model."){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new ChooseOpticsEvent());
        }
    };
    private final Action saveTwissAction = new NamedAction("Save Twiss", "Saves the actual twiss to a file."){
        {
            this.putValue("SmallIcon", Icon.SAVE.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMadGuiActions.this.publisher.publishEvent((Object)new SaveTwissEvent());
        }
    };
    private final Action showAboutBoxAction = new AbstractAction("About"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMadGuiActions.this.publisher.publishEvent((Object)new ShowAboutBoxEvent());
        }
    };

    public JMadGuiActions(ApplicationEventPublisher publisher, JMadGuiPreferences guiPreferences) {
        this.publisher = publisher;
        guiPreferences.enabledChangeModelProperty().subscribe(enable -> SwingUtilities.invokeLater(() -> {
            this.createModelAction.setEnabled((boolean)enable);
            this.createModelFromFileAction.setEnabled((boolean)enable);
            this.createModelFromRepositoryAction.setEnabled((boolean)enable);
            this.createModelFromUriAction.setEnabled((boolean)enable);
            this.closeActiveModelAction.setEnabled((boolean)enable);
        }), new SubscriptionOption[0]);
        guiPreferences.enabledChangeOpticProperty().subscribe(enable -> SwingUtilities.invokeLater(() -> this.chooseOpticsAction.setEnabled((boolean)enable)), new SubscriptionOption[0]);
        guiPreferences.enabledChangeRangeProperty().subscribe(enable -> SwingUtilities.invokeLater(() -> this.chooseRangeAction.setEnabled((boolean)enable)), new SubscriptionOption[0]);
    }

    public Action getCreateModelAction() {
        return this.createModelAction;
    }

    public Action getCreateModelFromRepositoryAction() {
        return this.createModelFromRepositoryAction;
    }

    public Action getCreateModelFromUriAction() {
        return this.createModelFromUriAction;
    }

    public Action getCreateModelFromFileAction() {
        return this.createModelFromFileAction;
    }

    public Action getExportModelAction() {
        return this.exportModelAction;
    }

    public Action getExportModelUriAction() {
        return this.exportModelUriAction;
    }

    public Action getCloseActiveModelAction() {
        return this.closeActiveModelAction;
    }

    public Action getExitAction() {
        return this.exitAction;
    }

    public Action getChooseRangeAction() {
        return this.chooseRangeAction;
    }

    public Action getChooseOpticsAction() {
        return this.chooseOpticsAction;
    }

    public Action getSaveTwissAction() {
        return this.saveTwissAction;
    }

    public Action getShowAboutBoxAction() {
        return this.showAboutBoxAction;
    }
}

