/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.tree;

import cern.accsoft.steering.util.gui.tree.FileTree;
import cern.accsoft.steering.util.gui.tree.IconData;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

class FileNode {
    protected File m_file;

    public FileNode(File file) {
        this.m_file = file;
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
    }

    public boolean expand(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode flag = (DefaultMutableTreeNode)parent.getFirstChild();
        if (flag == null) {
            return false;
        }
        Object obj = flag.getUserObject();
        if (!(obj instanceof Boolean)) {
            return false;
        }
        parent.removeAllChildren();
        File[] files = this.listFiles();
        if (files == null) {
            return true;
        }
        Vector<FileNode> v = new Vector<FileNode>();
        for (int k = 0; k < files.length; ++k) {
            File f = files[k];
            if (!f.isDirectory()) continue;
            FileNode newNode = new FileNode(f);
            boolean isAdded = false;
            for (int i = 0; i < v.size(); ++i) {
                FileNode nd = (FileNode)v.elementAt(i);
                if (newNode.compareTo(nd) >= 0) continue;
                v.insertElementAt(newNode, i);
                isAdded = true;
                break;
            }
            if (isAdded) continue;
            v.addElement(newNode);
        }
        for (int i = 0; i < v.size(); ++i) {
            FileNode nd = (FileNode)v.elementAt(i);
            IconData idata = new IconData(FileTree.ICON_FOLDER, FileTree.ICON_EXPANDEDFOLDER, nd);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
            parent.add(node);
            if (!nd.hasSubDirs()) continue;
            node.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        return true;
    }

    public boolean hasSubDirs() {
        File[] files = this.listFiles();
        if (files == null) {
            return false;
        }
        for (int k = 0; k < files.length; ++k) {
            if (!files[k].isDirectory()) continue;
            return true;
        }
        return false;
    }

    public int compareTo(FileNode toCompare) {
        return this.m_file.getName().compareToIgnoreCase(toCompare.m_file.getName());
    }

    protected File[] listFiles() {
        if (!this.m_file.isDirectory()) {
            return null;
        }
        try {
            return this.m_file.listFiles();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error reading directory " + this.m_file.getAbsolutePath(), "Warning", 2);
            return null;
        }
    }
}

