/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.chart;

import cern.jdve.Chart;
import cern.jdve.ChartInteractor;
import cern.jdve.ChartRenderer;
import cern.jdve.Style;
import cern.jdve.data.DataSet;
import cern.jdve.data.DataSource;
import cern.jdve.data.DefaultDataSet;
import cern.jdve.data.DefaultDataSource;
import cern.jdve.event.ChartInteractionListener;
import cern.jdve.graphic.DefaultRenderingHint;
import cern.jdve.graphic.MarkerFactory;
import cern.jdve.graphic.RenderingHint;
import cern.jdve.interactor.ZoomInteractor;
import cern.jdve.renderer.PolylineChartRenderer;
import cern.jdve.renderer.ScatterChartRenderer;
import cern.jdve.utils.DataWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class TuneDiagramChart
extends Chart {
    private static final long serialVersionUID = 1L;
    private final int MAX_NUMBER_OF_MARKER = 10;
    private ZoomInteractor fzoomInteractor;
    private ScatterChartRenderer fScatterChartRenderer;
    private PolylineChartRenderer fpolyrenderer;
    private DefaultDataSource fresonances = new DefaultDataSource();
    private DefaultDataSet fdataset = new DefaultDataSet("TuneTrace");
    private Collection<ChartInteractionListener> flisteners = new ArrayList<ChartInteractionListener>();
    private Style[] fstyles = new Style[10];
    private Style[] flinestyles = new Style[24];
    private int fresonanceOrder = 10;

    public TuneDiagramChart(int resonanceOrder) {
        this.fresonanceOrder = resonanceOrder;
        this.setName("TuneDiagram");
        this.setPreferredSize(new Dimension(500, 300));
        this.setAntiAliasing(true);
        this.setAntiAliasingText(true);
        this.setRenderingType(2);
        this.getYGrid().setMinorLineVisible(true);
        this.getYGrid().setMinorColor(new Color(230, 230, 230));
        this.getXScale().setTitleAlignment(4);
        this.getYScale().setTitleAlignment(4);
        this.setAntiAliasing(false);
        this.setXScaleTitle("Q1 [2 pi]");
        this.setYScaleTitle("Q2 [2 pi]");
        this.setDoubleBuffered(true);
        this.setDataSet((DataSet)this.fdataset);
        this.fScatterChartRenderer = new ScatterChartRenderer();
        this.fScatterChartRenderer.setDataSet((DataSet)this.fdataset);
        this.addRenderer((ChartRenderer)this.fScatterChartRenderer);
        this.updateTuneMarkerStyles(10);
        this.fzoomInteractor = new ZoomInteractor();
        this.fzoomInteractor.setAnimationStep(0);
        this.fzoomInteractor.setOutOfRangeZoomAllowed(false);
        this.addInteractor((ChartInteractor)this.fzoomInteractor);
        this.drawResonanceLines(true, true, this.fresonanceOrder);
    }

    private void updateTuneMarkerStyles(int maxMarker) {
        int i;
        int tmaxMarker = Math.min(maxMarker, 10);
        if (tmaxMarker <= 0) {
            tmaxMarker = 1;
        }
        this.fstyles = new Style[tmaxMarker];
        int scale = (int)(255.0 / ((double)tmaxMarker * 1.1));
        for (i = 0; i < this.fstyles.length; ++i) {
            Color c = new Color(i * scale, i * scale, 255);
            this.fstyles[i] = new Style((Stroke)new BasicStroke(1.5f), c, c);
        }
        this.fScatterChartRenderer.setMarker(MarkerFactory.getMarker((int)2));
        this.fScatterChartRenderer.setMarkerSize(10);
        for (i = 0; i < this.fstyles.length; ++i) {
            this.fScatterChartRenderer.setRenderingHint((DataSet)this.fdataset, i, (RenderingHint)new DefaultRenderingHint(this.fstyles[this.fstyles.length - 1 - i]));
        }
    }

    private double Qtrafo(double val, boolean below) {
        if (below) {
            return val;
        }
        return 1.0 - val;
    }

    private void drawResonanceLines(boolean Qxbelow, boolean Qybelow, int resonanceOrder) {
        boolean update = false;
        if (this.fpolyrenderer != null) {
            update = true;
        } else {
            update = false;
            Color c = new Color(255, 0, 0);
            this.flinestyles[0] = new Style((Stroke)new BasicStroke(1.5f), c, c);
            c = new Color(0, 0, 255);
            this.flinestyles[1] = new Style((Stroke)new BasicStroke(1.5f), c, c);
            this.flinestyles[2] = new Style((Stroke)new BasicStroke(1.5f), c, c);
            this.flinestyles[3] = new Style((Stroke)new BasicStroke(1.5f), c, c);
            c = new Color(100, 100, 100);
            this.flinestyles[4] = new Style((Stroke)new BasicStroke(1.0f), c, c);
            this.flinestyles[5] = new Style((Stroke)new BasicStroke(1.0f), c, c);
            c = new Color(100, 100, 100);
            this.flinestyles[6] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[7] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[8] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[9] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[10] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[11] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[12] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            c = new Color(150, 150, 150);
            this.flinestyles[13] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[14] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[15] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[16] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[17] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[18] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[19] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[20] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[21] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[22] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.flinestyles[23] = new Style((Stroke)new BasicStroke(0.5f), c, c);
            this.fpolyrenderer = new PolylineChartRenderer();
            this.fpolyrenderer.setStyles(this.flinestyles);
        }
        this.fresonances = new DefaultDataSource();
        DefaultDataSet dataframe = new DefaultDataSet("frame");
        dataframe.setEditable(true);
        dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.0, Qybelow));
        dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.0, Qybelow));
        dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.5, Qybelow));
        dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.5, Qybelow));
        dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.0, Qybelow));
        dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.5, Qybelow));
        this.fresonances.addDataSet((DataSet)dataframe);
        if (resonanceOrder >= 3) {
            dataframe = new DefaultDataSet("third_1");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("third_2");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.3333333333333333, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.3333333333333333, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("third_3");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.3333333333333333, Qxbelow), this.Qtrafo(0.5, Qybelow));
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
        }
        if (resonanceOrder >= 4) {
            dataframe = new DefaultDataSet("fourth_1");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.25, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.25, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fourth_2");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.25, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.25, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
        }
        if (resonanceOrder >= 5) {
            dataframe = new DefaultDataSet("fifth_1");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.2, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.2, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fifth_2");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.4, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.4, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fifth_3");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.2, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.2, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fifth_4");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.4, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.4, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fifth_5");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.5, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.0, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fifth_6");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.16666666666666666, Qxbelow), this.Qtrafo(0.5, Qybelow));
            dataframe.add(this.Qtrafo(0.3333333333333333, Qxbelow), this.Qtrafo(0.0, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("fifth_7");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.16666666666666666, Qybelow));
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
        }
        if (resonanceOrder >= 6) {
            dataframe = new DefaultDataSet("sixth_1");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.16666666666666666, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.16666666666666666, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_2");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.16666666666666666, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.16666666666666666, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_3");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.25, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.125, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_4");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.3333333333333333, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_5");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_6");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.0, Qybelow));
            dataframe.add(this.Qtrafo(0.375, Qxbelow), this.Qtrafo(0.5, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_7");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.25, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.12569, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_8");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.16666666666666666, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_9");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.0, Qxbelow), this.Qtrafo(0.5, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.375, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_10");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.25, Qxbelow), this.Qtrafo(0.5, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.3333333333333333, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
            dataframe = new DefaultDataSet("sixth_11");
            dataframe.setEditable(true);
            dataframe.add(this.Qtrafo(0.3333333333333333, Qxbelow), this.Qtrafo(0.5, Qybelow));
            dataframe.add(this.Qtrafo(0.5, Qxbelow), this.Qtrafo(0.25, Qybelow));
            this.fresonances.addDataSet((DataSet)dataframe);
        }
        if (resonanceOrder >= 7) {
            // empty if block
        }
        if (resonanceOrder >= 8) {
            // empty if block
        }
        this.fpolyrenderer.setDataSource((DataSource)this.fresonances);
        if (!update) {
            this.addRenderer((ChartRenderer)this.fpolyrenderer);
        }
    }

    public void setXZoomAllowed(boolean zoom_mode) {
        this.fzoomInteractor.setXZoomAllowed(true);
    }

    public void setYZoomAllowed(boolean zoom_mode) {
        this.fzoomInteractor.setYZoomAllowed(true);
    }

    public void setBothZoomAllowed() {
        this.fzoomInteractor.setXZoomAllowed(true);
        this.fzoomInteractor.setYZoomAllowed(true);
    }

    public void setXZoomAllowedOnly() {
        this.fzoomInteractor.setXZoomAllowed(true);
        this.fzoomInteractor.setYZoomAllowed(false);
    }

    public void setYZoomAllowedOnly() {
        this.fzoomInteractor.setXZoomAllowed(false);
        this.fzoomInteractor.setYZoomAllowed(true);
    }

    public void zoomToOrigin() {
        this.zoom(this.fdataset.getXRange().getMin(), this.fdataset.getXRange().getMax(), this.fdataset.getYRange().getMin(), this.fdataset.getYRange().getMax());
    }

    public void zoomLimit(double minX, double maxX, double minY, double maxY) {
        double min_x = this.fdataset.getXRange().getMin();
        double max_x = this.fdataset.getXRange().getMax();
        double min_y = this.fdataset.getYRange().getMin();
        double max_y = this.fdataset.getYRange().getMax();
        if (!Double.valueOf(minX).isNaN()) {
            min_x = minX;
        }
        if (!Double.valueOf(maxX).isNaN()) {
            max_x = maxX;
        }
        if (!Double.valueOf(minY).isNaN()) {
            min_y = minY;
        }
        if (!Double.valueOf(maxY).isNaN()) {
            max_y = maxY;
        }
        this.zoom(min_x, max_x, min_y, max_y);
    }

    private void zoom(double minX, double maxX, double minY, double maxY) {
        double temp;
        boolean isAdjusting = this.isAdjusting();
        if (!isAdjusting) {
            this.setAdjusting(true);
        }
        this.fzoomInteractor.clearZoomList();
        if (minX > maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY > maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        if (minX == maxX) {
            maxX += 1.0;
        }
        if (minY == maxY) {
            maxY += 1.0;
        }
        this.zoom(0, new DataWindow(minX, maxX, minY, maxY));
        if (!isAdjusting) {
            this.setAdjusting(false);
        }
    }

    private double adjustToHalfInteger(double value, boolean aboveHalfInteger) {
        if (aboveHalfInteger && value < 0.5 || !aboveHalfInteger && value > 0.5) {
            return 1.0 - value;
        }
        return value;
    }

    private void set(double[] qXValues, double[] qYValues) {
        int length = qXValues.length;
        if (qYValues.length != length) {
            throw new IllegalArgumentException("Arrays for Qx and Qy must be of same length!");
        }
        if (length > 10) {
            length = 10;
        }
        boolean xAboveHalfInteger = this.isAboveHalfInteger(qXValues);
        boolean yAboveHalfInteger = this.isAboveHalfInteger(qYValues);
        this.setAdjusting(true);
        double xmin = 1.0E99;
        double xmax = -1.0E99;
        double ymin = 1.0E99;
        double ymax = -1.0E99;
        double[] xtrace = new double[length];
        double[] ytrace = new double[length];
        for (int i = 0; i < length; ++i) {
            double x = this.adjustToHalfInteger(qXValues[i], xAboveHalfInteger);
            double y = this.adjustToHalfInteger(qYValues[i], yAboveHalfInteger);
            if (i < xtrace.length) {
                xtrace[i] = x;
                ytrace[i] = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (x < xmin) {
                xmin = x;
            }
            if (y > ymax) {
                ymax = y;
            }
            if (!(y < ymin)) continue;
            ymin = y;
        }
        this.fdataset.set(xtrace, ytrace);
        this.updateTuneMarkerStyles(xtrace.length);
        this.getXAxis().setRange(0.9 * xmin, 1.1 * xmax);
        this.getYAxis().setRange(0.9 * ymin, 1.1 * ymax);
        this.setAdjusting(false);
    }

    public void addChartInteractionEventListener(ChartInteractionListener listener) {
        this.flisteners.add(listener);
    }

    public void removeChartInteractionListener(ChartInteractionListener listener) {
        if (this.flisteners != null) {
            this.flisteners.remove(listener);
        }
    }

    private boolean isAboveHalfInteger(double[] values) {
        if (values.length < 1) {
            return false;
        }
        return values[0] > 0.5;
    }

    public void setValues(double qX, double qY) {
        this.setValues(new double[]{qX}, new double[]{qY});
    }

    public void setValues(double[] qXValues, double[] qYValues) {
        if (!this.isAdjusting() && this.isShowing()) {
            double[] qXCopy = TuneDiagramChart.getFractionalPart(qXValues);
            double[] qYCOpy = TuneDiagramChart.getFractionalPart(qYValues);
            this.drawResonanceLines(!this.isAboveHalfInteger(qXCopy), !this.isAboveHalfInteger(qYCOpy), this.fresonanceOrder);
            this.set(qXCopy, qYCOpy);
        }
    }

    private static final double[] getFractionalPart(double[] values) {
        double[] valuesCopy = Arrays.copyOf(values, values.length);
        for (int i = 0; i < valuesCopy.length; ++i) {
            double value = valuesCopy[i];
            valuesCopy[i] = value - Math.floor(value);
        }
        return valuesCopy;
    }
}

