/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.elem.Element;
import cern.accsoft.steering.jmad.domain.elem.JMadElementType;
import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.domain.machine.Range;
import cern.accsoft.steering.jmad.domain.misalign.MisalignmentConfiguration;
import cern.accsoft.steering.jmad.domain.optics.OpticPoint;
import cern.accsoft.steering.jmad.gui.components.DoubleTableCellRenderer;
import cern.accsoft.steering.jmad.gui.manage.ElementSelectionManager;
import cern.accsoft.steering.jmad.gui.mark.MarkedElementsManager;
import cern.accsoft.steering.jmad.gui.mark.MarkedElementsManagerListener;
import cern.accsoft.steering.jmad.gui.panels.EditHandlerUser;
import cern.accsoft.steering.jmad.gui.panels.ModelElementsPanelEditHandler;
import cern.accsoft.steering.jmad.gui.panels.TablePanelEditHandler;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelListener;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.util.gui.CompUtils;
import cern.accsoft.steering.util.gui.menu.ActionProvider;
import cern.accsoft.steering.util.gui.menu.MousePopupListener;
import cern.accsoft.steering.util.gui.menu.TablePopupMenu;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import cern.accsoft.steering.util.gui.table.BeanTableModel;
import cern.accsoft.steering.util.gui.table.SelectionSetTableModel;
import cern.accsoft.steering.util.gui.table.TableModelSelectionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelElementsPanel
extends JPanel
implements EditHandlerUser<ModelElementsPanelEditHandler> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ModelElementsPanel.class);
    private static final int DIVIDER_LOCATION = 250;
    private ModelElementsPanelEditHandler editHandler;
    private JMadModelManager modelManager;
    private MarkedElementsManager markedElementsManager;
    private ElementSelectionManager elementSelectionManager;
    private ModelElementsTableModel tableModelElements = null;
    private ModelElementTableModel tableModelElement = null;
    private BeanTableModel tableModelElementOptic = null;
    private JTextField txtElementName = null;
    private JMadModelListener modelListener = new JMadModelListener(){

        public void elementsChanged() {
            ModelElementsPanel.this.tableModelElement.fireTableDataChanged();
            ModelElementsPanel.this.validate();
        }

        public void opticsChanged() {
            ModelElementsPanel.this.tableModelElementOptic.fireTableDataChanged();
            ModelElementsPanel.this.validate();
        }

        public void rangeChanged(Range newRange) {
            ModelElementsPanel.this.tableModelElements.fireTableDataChanged();
            ModelElementsPanel.this.validate();
        }

        public void becameDirty() {
        }

        public void opticsDefinitionChanged() {
        }
    };

    public ModelElementsPanel() {
        super(new BorderLayout());
        this.initComponents();
    }

    public final void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        if (this.modelManager.getActiveModel() != null) {
            this.modelManager.getActiveModel().addListener(this.modelListener);
        }
        modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newModel) {
                if (newModel != null) {
                    newModel.addListener(ModelElementsPanel.this.modelListener);
                }
                ModelElementsPanel.this.tableModelElements.fireTableDataChanged();
            }
        });
    }

    private final void initComponents() {
        JPanel listPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        this.tableModelElements = new ModelElementsTableModel();
        JTable table = new JTable(this.tableModelElements);
        table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        table.setAutoCreateRowSorter(true);
        table.getSelectionModel().setSelectionMode(1);
        table.getSelectionModel().addListSelectionListener(new ElementSelectionAdapter(table));
        this.tableModelElements.setTableModelSelectionAdapter(new TableModelSelectionAdapter(table));
        JScrollPane elementsScrollPane = CompUtils.createScrollPane(table);
        new MousePopupListener(table, new TablePopupMenu(new MisalignmentCreator()));
        listPanel.add((Component)new TableFilterPanel(table), constraints);
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        listPanel.add((Component)elementsScrollPane, constraints);
        JPanel detailPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        this.txtElementName = new JTextField();
        this.txtElementName.setEditable(false);
        detailPanel.add((Component)this.txtElementName, constraints);
        constraints.weighty = 1.0;
        ++constraints.gridy;
        this.tableModelElement = new ModelElementTableModel();
        table = new JTable(this.tableModelElement);
        table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        detailPanel.add((Component)CompUtils.createScrollPane(table), constraints);
        ++constraints.gridy;
        this.tableModelElementOptic = new BeanTableModel(OpticPoint.class);
        table = new JTable(this.tableModelElementOptic);
        table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        detailPanel.add((Component)CompUtils.createScrollPane(table), constraints);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(listPanel);
        splitPane.setRightComponent(detailPanel);
        this.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(250);
    }

    private ArrayList<Element> getSelectedElements() {
        Range range;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (this.modelManager != null && (range = this.modelManager.getActiveModel().getActiveRange()) != null) {
            for (Integer index : this.tableModelElements.getTableModelSelectionAdapter().getSelectedRowIndizes()) {
                elements.add((Element)range.getElements().get(index));
            }
        }
        return elements;
    }

    private Element getElement(int modelIndex) {
        Range range;
        if (modelIndex >= 0 && this.modelManager != null && (range = this.modelManager.getActiveModel().getActiveRange()) != null) {
            return (Element)range.getElements().get(modelIndex);
        }
        return null;
    }

    private void displayElementDetails(Element element) {
        if (element != null) {
            this.txtElementName.setText(element.getName());
            this.tableModelElement.setElement(element);
            this.tableModelElementOptic.setBean(this.getElementOptics(element));
        } else {
            this.txtElementName.setText("");
            this.tableModelElement.setElement(null);
            this.tableModelElementOptic.setBean(null);
        }
    }

    private OpticPoint getElementOptics(Element element) {
        JMadModel model = this.modelManager.getActiveModel();
        try {
            return model.getOptics().getPoint(element);
        }
        catch (JMadModelException e) {
            logger.warn("no optics-information found for element '" + element.getName() + "'", (Throwable)e);
            return null;
        }
    }

    public final ModelElementsPanelEditHandler getEditHandler() {
        return this.editHandler;
    }

    @Override
    public final void setEditHandler(TablePanelEditHandler editHandler) {
        if (editHandler instanceof ModelElementsPanelEditHandler) {
            this.editHandler = (ModelElementsPanelEditHandler)editHandler;
        }
    }

    public void setMarkedElementsManager(MarkedElementsManager markedElementsManager) {
        this.markedElementsManager = markedElementsManager;
        markedElementsManager.addListener(new MarkedElementsManagerListener(){

            @Override
            public void addedElementName(String elementName) {
                ModelElementsPanel.this.tableModelElements.fireTableDataChanged();
            }

            @Override
            public void removedElementName(String elementName) {
                ModelElementsPanel.this.tableModelElements.fireTableDataChanged();
            }
        });
    }

    private MarkedElementsManager getMarkedElementsManager() {
        return this.markedElementsManager;
    }

    public void setElementSelectionManager(ElementSelectionManager elementSelectionManager) {
        this.elementSelectionManager = elementSelectionManager;
    }

    private ElementSelectionManager getElementSelectionManager() {
        return this.elementSelectionManager;
    }

    private class ModelElementTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int DEFAULT_ATTRIBUTE_COUNT = 1;
        private static final int ROW_POSITION = 0;
        private static final String NAME_POSITIONE = "position";
        private static final int COLUMN_COUNT = 3;
        private static final int COL_SELECTED = 0;
        private static final int COL_ATTR_NAME = 1;
        private static final int COL_ATTR_VALUE = 2;
        private Element element = null;

        private ModelElementTableModel() {
        }

        public void setElement(Element element) {
            this.element = element;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (this.element != null) {
                return this.element.getAttributeNames().size() + 1;
            }
            return 0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row != 0 && col != 1) {
                return this.getValueAt(row, 2) != null;
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.element == null) {
                return null;
            }
            switch (col) {
                case 1: {
                    if (row == 0) {
                        return NAME_POSITIONE;
                    }
                    return this.element.getAttributeNames().get(row - 1);
                }
                case 2: {
                    if (row == 0) {
                        return this.element.getPosition().getValue();
                    }
                    return this.element.getAttribute((String)this.element.getAttributeNames().get(row - 1));
                }
                case 0: {
                    if (row == 0) {
                        return false;
                    }
                    if (ModelElementsPanel.this.editHandler != null) {
                        return ModelElementsPanel.this.editHandler.getSelectionValue(this.element, (String)this.element.getAttributeNames().get(row - 1));
                    }
                    return false;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < 1) {
                return;
            }
            String attributeName = (String)this.element.getAttributeNames().get(row - 1);
            switch (col) {
                case 0: {
                    if (ModelElementsPanel.this.editHandler == null) break;
                    ArrayList elements = ModelElementsPanel.this.getSelectedElements();
                    for (Element elem : elements) {
                        ModelElementsPanel.this.editHandler.setSelectionValue(elem, attributeName, (Boolean)value);
                    }
                    this.fireTableCellUpdated(row, col);
                    break;
                }
                case 2: {
                    ArrayList elements = ModelElementsPanel.this.getSelectedElements();
                    for (Element elem : elements) {
                        elem.setAttribute(attributeName, (Double)value);
                    }
                    this.fireTableCellUpdated(row, col);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Double.class;
                }
                case 0: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 1: {
                    return "attribute name";
                }
                case 2: {
                    return "value";
                }
                case 0: {
                    if (ModelElementsPanel.this.editHandler != null) {
                        return ModelElementsPanel.this.editHandler.getCheckableColumnHeader();
                    }
                    return "selected";
                }
            }
            return null;
        }
    }

    private class ModelElementsTableModel
    extends SelectionSetTableModel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMN_COUNT = 4;
        private static final int COL_NUMBER = 0;
        private static final int COL_MARK = 1;
        private static final int COL_NAME = 2;
        private static final int COL_TYPE = 3;

        private ModelElementsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            if (ModelElementsPanel.this.modelManager == null || ModelElementsPanel.this.modelManager.getActiveModel() == null || ModelElementsPanel.this.modelManager.getActiveModel().getActiveRange() == null) {
                return 0;
            }
            return this.getElements().size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (ModelElementsPanel.this.modelManager == null) {
                return;
            }
            if (col == 1) {
                if (ModelElementsPanel.this.getMarkedElementsManager() == null) {
                    return;
                }
                Element element = (Element)ModelElementsPanel.this.modelManager.getActiveModel().getActiveRange().getElements().get(row);
                if (((Boolean)value).booleanValue()) {
                    ModelElementsPanel.this.getMarkedElementsManager().addElementName(element.getName());
                } else {
                    ModelElementsPanel.this.getMarkedElementsManager().removeElementName(element.getName());
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (ModelElementsPanel.this.modelManager == null) {
                return null;
            }
            Element element = (Element)ModelElementsPanel.this.modelManager.getActiveModel().getActiveRange().getElements().get(row);
            switch (col) {
                case 0: {
                    return row;
                }
                case 1: {
                    if (ModelElementsPanel.this.getMarkedElementsManager() == null) {
                        return false;
                    }
                    return ModelElementsPanel.this.getMarkedElementsManager().contains(element.getName());
                }
                case 2: {
                    return element.getName();
                }
                case 3: {
                    return JMadElementType.fromElement((Element)element).toString();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "number";
                }
                case 1: {
                    return "mark";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "type";
                }
            }
            return null;
        }

        private List<Element> getElements() {
            if (ModelElementsPanel.this.modelManager != null && ModelElementsPanel.this.modelManager.getActiveModel() != null && ModelElementsPanel.this.modelManager.getActiveModel().getActiveRange() != null) {
                return ModelElementsPanel.this.modelManager.getActiveModel().getActiveRange().getElements();
            }
            return new ArrayList<Element>();
        }
    }

    private class ElementSelectionAdapter
    implements ListSelectionListener {
        private JTable table = null;

        public ElementSelectionAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getSource() == this.table.getSelectionModel()) {
                int index = this.table.getSelectedRow();
                Element element = null;
                if (index >= 0) {
                    element = ModelElementsPanel.this.getElement(this.table.convertRowIndexToModel(index));
                }
                ModelElementsPanel.this.displayElementDetails(element);
                if (ModelElementsPanel.this.getElementSelectionManager() != null) {
                    ModelElementsPanel.this.getElementSelectionManager().setSelectedElements(ModelElementsPanel.this.getSelectedElements(), element);
                }
            }
        }
    }

    private class MisalignmentCreator
    implements ActionProvider {
        private Action createMisalignmentsAction = new AbstractAction("create misalignments"){
            private static final long serialVersionUID = -7332873258819061907L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrayList elements = ModelElementsPanel.this.getSelectedElements();
                for (Element element : elements) {
                    Range range = ModelElementsPanel.this.modelManager.getActiveModel().getActiveRange();
                    range.addMisalignment(new MisalignmentConfiguration(element.getName()));
                }
            }
        };

        private MisalignmentCreator() {
        }

        @Override
        public List<Action> getActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(this.createMisalignmentsAction);
            return actions;
        }
    }
}

