/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.machine.RangeDefinition;
import cern.accsoft.steering.jmad.gui.panels.RangeSelectionPanel;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelStartupConfiguration;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.jmad.modeldefs.JMadModelDefinitionManager;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import cern.accsoft.steering.jmad.service.JMadService;
import cern.accsoft.steering.util.gui.panels.Applyable;
import cern.accsoft.steering.util.gui.panels.Titleable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDefinitionSelectionPanel
extends JPanel
implements Titleable,
Applyable {
    private static final Logger logger = LoggerFactory.getLogger(ModelDefinitionSelectionPanel.class);
    private static final long serialVersionUID = -3095464304653777882L;
    private JMadService jmadService;
    private JComboBox cboModel;
    private JMadModelStartupConfiguration jmadModelStartupConfiguration = null;
    private ActionListener modelSelectionComboListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelDefinitionSelectionPanel.this.updateSubPanels();
        }
    };
    private RangeSelectionPanel rangeSelectionPanel;

    public ModelDefinitionSelectionPanel() {
    }

    private void updateSubPanels() {
        JMadModelDefinition modelDefinition;
        if (this.rangeSelectionPanel != null && (modelDefinition = this.getActiveModelDefinition()) != null) {
            this.rangeSelectionPanel.setActiveModelDefinition(modelDefinition, modelDefinition.getDefaultSequenceDefinition().getDefaultRangeDefinition());
        }
    }

    public ModelDefinitionSelectionPanel(boolean showRangeSelection) {
        if (showRangeSelection) {
            this.rangeSelectionPanel = new RangeSelectionPanel();
            this.rangeSelectionPanel.init();
        }
    }

    public void init() {
        this.initComponenets();
    }

    private void initComponenets() {
        JMadModel model;
        this.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel(new GridBagLayout());
        this.add((Component)comboPanel, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        comboPanel.add((Component)new JLabel("Model: "), constraints);
        ++constraints.gridx;
        this.cboModel = this.createModelSelectionComboBox();
        comboPanel.add((Component)this.cboModel, constraints);
        if (this.rangeSelectionPanel != null) {
            this.add((Component)this.rangeSelectionPanel, "South");
        }
        this.updateSubPanels();
        if (this.getModelManager() != null && (model = this.getModelManager().getActiveModel()) != null) {
            this.setActiveModel(model);
        }
    }

    private void setActiveModel(JMadModel model) {
        if (model == null) {
            return;
        }
        this.setActiveModelDefinition(model.getModelDefinition());
        if (this.rangeSelectionPanel != null) {
            this.rangeSelectionPanel.setActiveModel(model);
        }
    }

    public void setActiveModelDefinition(JMadModelDefinition modelDefinition) {
        this.cboModel.setSelectedItem(modelDefinition);
    }

    public JMadModelDefinition getActiveModelDefinition() {
        return (JMadModelDefinition)this.cboModel.getSelectedItem();
    }

    private JComboBox createModelSelectionComboBox() {
        JComboBox<Object> comboBox = new JComboBox<Object>(this.getModelDefinitionManager().getAllModelDefinitions().toArray());
        comboBox.setToolTipText("Selects the actual model.");
        comboBox.addActionListener(this.modelSelectionComboListener);
        return comboBox;
    }

    @Override
    public String getTitle() {
        return "Select model";
    }

    @Override
    public boolean apply() {
        RangeDefinition rangeDefinition = null;
        this.jmadModelStartupConfiguration = null;
        if (this.rangeSelectionPanel != null && (rangeDefinition = this.rangeSelectionPanel.getActiveRangeDefinition()) != null) {
            JMadModelStartupConfiguration startupConfiguration = new JMadModelStartupConfiguration();
            startupConfiguration.setInitialRangeDefinition(rangeDefinition);
            startupConfiguration.setLoadDefaultRange(false);
            this.jmadModelStartupConfiguration = startupConfiguration;
        }
        return this.getActiveModelDefinition() != null;
    }

    @Override
    public void cancel() {
    }

    public void setJmadService(JMadService jmadService) {
        this.jmadService = jmadService;
        this.jmadService.getModelManager().addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel model) {
                ModelDefinitionSelectionPanel.this.setActiveModel(model);
            }
        });
    }

    private JMadService getJmadService() {
        if (this.jmadService == null) {
            logger.warn("jmadService not set. Maybe config error.");
        }
        return this.jmadService;
    }

    private JMadModelManager getModelManager() {
        if (this.getJmadService() == null) {
            return null;
        }
        return this.getJmadService().getModelManager();
    }

    private JMadModelDefinitionManager getModelDefinitionManager() {
        return this.getJmadService().getModelDefinitionManager();
    }

    public JMadModelStartupConfiguration getStartupConfiguration() {
        return this.jmadModelStartupConfiguration;
    }
}

