/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.manage.impl;

import cern.accsoft.steering.jmad.gui.manage.CustomFileManager;
import cern.accsoft.steering.jmad.gui.manage.CustomFileManagerListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CustomFileManagerImpl
implements CustomFileManager {
    private List<File> files = new ArrayList<File>();
    private List<CustomFileManagerListener> listeners = new ArrayList<CustomFileManagerListener>();

    @Override
    public void add(File file) {
        this.files.add(file);
        this.fireChangedFiles();
    }

    @Override
    public void remove(File file) {
        this.files.remove(file);
        this.fireChangedFiles();
    }

    @Override
    public List<File> getFiles() {
        return this.files;
    }

    private void fireChangedFiles() {
        for (CustomFileManagerListener listener : this.listeners) {
            listener.changedFiles();
        }
    }

    @Override
    public void addListener(CustomFileManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(CustomFileManagerListener listener) {
        this.listeners.remove(listener);
    }
}

