/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.manage;

import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.domain.result.tfs.TfsResult;
import cern.accsoft.steering.jmad.domain.result.tfs.TfsResultRequest;
import cern.accsoft.steering.jmad.domain.result.tfs.TfsResultRequestImpl;
import cern.accsoft.steering.jmad.domain.var.MadxVariable;
import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.domain.var.Variable;
import cern.accsoft.steering.jmad.gui.data.TfsResultDataSet;
import cern.accsoft.steering.jmad.gui.manage.AllVarManager;
import cern.accsoft.steering.jmad.gui.manage.DataSetManager;
import cern.accsoft.steering.jmad.gui.manage.DataSetManagerListener;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsDataSetManager
implements DataSetManager {
    private static final Logger logger = LoggerFactory.getLogger(TfsDataSetManager.class);
    private JMadModelManager modelManager = null;
    private ArrayList<DataSetManagerListener> listeners = new ArrayList();
    private Map<String, TwissVariable> requiredVariables = new HashMap<String, TwissVariable>();
    private ArrayList<TfsResultDataSet> dataSets = new ArrayList();
    private AllVarManager allVarManager;
    private TfsResult tfsResult = null;
    private TfsResult referenceTfsResult = null;
    private final JMadModelManagerListener modelManagerListener = new JMadModelManagerAdapter(){

        public void changedActiveModel(JMadModel newModel) {
            TfsDataSetManager.this.resetReference();
        }
    };

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        modelManager.addListener(this.modelManagerListener);
    }

    private JMadModel getModel() {
        if (this.modelManager != null) {
            return this.modelManager.getActiveModel();
        }
        return null;
    }

    public Map<Integer, List<TfsResultDataSet>> createDataSets(TwissVariable xVar, Map<Integer, Collection<TwissVariable>> yVars, TfsResultDataSet.TfsResultDataSetType type) {
        this.requiredVariables.put(xVar.getMadxName(), xVar);
        for (Integer yAxis : yVars.keySet()) {
            for (TwissVariable var : yVars.get(yAxis)) {
                this.requiredVariables.put(var.getMadxName(), var);
            }
        }
        this.refresh();
        HashMap<Integer, List<TfsResultDataSet>> newDataSets = new HashMap<Integer, List<TfsResultDataSet>>();
        for (Integer yAxis : yVars.keySet()) {
            Collection<TwissVariable> variables = yVars.get(yAxis);
            if (variables.size() <= 0) continue;
            ArrayList<TfsResultDataSet> dsList = new ArrayList<TfsResultDataSet>();
            newDataSets.put(yAxis, dsList);
            for (TwissVariable var : variables) {
                TfsResultDataSet dataSet = this.createDataSet((MadxVariable)xVar, var, type, yAxis);
                dsList.add(dataSet);
                if (!var.isApertureVariable()) continue;
                dataSet = this.createDataSet((MadxVariable)xVar, var, type, yAxis + 1);
                dataSet.setFactor(-1.0);
                dsList.add(dataSet);
            }
        }
        return newDataSets;
    }

    private TfsResultDataSet createDataSet(MadxVariable xVar, TwissVariable yVar, TfsResultDataSet.TfsResultDataSetType type, Integer axis) {
        String dsName = yVar.toString();
        dsName = dsName + " (Y" + (axis + 1) + ")";
        TfsResultDataSet dataSet = new TfsResultDataSet(dsName, xVar, yVar, type, this.tfsResult, this.referenceTfsResult);
        this.dataSets.add(dataSet);
        return dataSet;
    }

    public void createDataSets(String name, TwissVariable xVar, Map<Integer, Collection<TwissVariable>> yVars, TfsResultDataSet.TfsResultDataSetType type) {
        Map<Integer, List<TfsResultDataSet>> dataSets = this.createDataSets(xVar, yVars, type);
        if (name == null || name.length() == 0) {
            name = "";
            for (Integer yAxis : yVars.keySet()) {
                Collection<TwissVariable> vars = yVars.get(yAxis);
                if (vars == null || vars.size() <= 0) continue;
                for (Variable variable : vars) {
                    if (name.length() > 0) {
                        name = name + ", ";
                    }
                    name = name + variable.getName() + "(" + xVar.getName() + ")";
                }
            }
            name = name + " [" + type.toString() + "]";
        }
        String xLabel = xVar.toString();
        this.fireCreatedDataSets(name, xLabel, dataSets);
    }

    public void refresh() {
        this.tfsResult = this.runTwiss(this.requiredVariables.values());
        if (this.tfsResult != null) {
            for (TfsResultDataSet dataSet : this.dataSets) {
                dataSet.setTfsResult(this.tfsResult);
            }
        }
        this.publishTfsResult();
    }

    private void publishTfsResult() {
        if (this.tfsResult != null) {
            for (DataSetManagerListener listener : this.listeners) {
                listener.twissCalculated(this.tfsResult);
            }
        }
    }

    public void setAsReference() {
        this.referenceTfsResult = this.runTwiss(this.getAllVarManager().getAllSelectableVariables());
        if (this.referenceTfsResult != null) {
            for (TfsResultDataSet dataSet : this.dataSets) {
                dataSet.setReferenceTfsResult(this.referenceTfsResult);
            }
        }
    }

    public void resetReference() {
        this.referenceTfsResult = null;
        for (TfsResultDataSet dataSet : this.dataSets) {
            dataSet.setReferenceTfsResult(null);
        }
    }

    private TfsResult runTwiss(Collection<TwissVariable> variables) {
        if (this.getModel() == null) {
            logger.warn("Model not set. Cannot refresh datasets!");
            return null;
        }
        TfsResultRequestImpl request = new TfsResultRequestImpl();
        request.addElementFilter(".*");
        request.addVariable((TwissVariable)TfsResultDataSet.LABEL_VAR);
        for (TwissVariable var : variables) {
            request.addVariable(var);
        }
        TfsResult result = null;
        try {
            result = this.getModel().twiss((TfsResultRequest)request);
        }
        catch (JMadModelException e) {
            logger.error("Error while running Twiss on model.", (Throwable)e);
        }
        return result;
    }

    private void fireCreatedDataSets(String name, String xLabel, Map<Integer, List<TfsResultDataSet>> dataSets) {
        for (DataSetManagerListener listener : this.listeners) {
            listener.createdDataSets(name, xLabel, dataSets);
        }
    }

    @Override
    public void addListener(DataSetManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DataSetManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void setAllVarManager(AllVarManager allVarManager) {
        this.allVarManager = allVarManager;
    }

    private AllVarManager getAllVarManager() {
        return this.allVarManager;
    }
}

