// @formatter:off
 /*******************************************************************************
 *
 * This file is part of JMad.
 * 
 * Copyright (c) 2008-2011, CERN. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ******************************************************************************/
// @formatter:on

package cern.accsoft.steering.util.gui.dv.ds;

/**
 * This Interface must be implemented by all datasets, which shall allow a different style for different datapoints.
 * 
 * @author Kajetan Fuchsberger (kajetan.fuchsberger at cern.ch)
 */
public interface ValidityDataSet {

    /**
     * return the style for a given Datapoint
     * 
     * @param index the index for which to retrieve the style
     * @return the Style
     */
    boolean getValidity(int index);

    /**
     * should return, if validity-information is available, false otherwise.
     * 
     * @return true, if validity information is available, false otherwise
     */
    boolean hasValidityInformation();
}
