/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import cern.accsoft.steering.util.fit.DataViewerFit;
import cern.accsoft.steering.util.fit.SineFit;
import cern.accsoft.steering.util.gui.icons.Icon;
import cern.jdve.data.DataSet;
import cern.jdve.interactor.EditInteractor;
import cern.jdve.utils.DataRange;
import cern.jdve.utils.DisplayPoint;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SineFitInteractor
extends EditInteractor {
    private static final Logger logger = LoggerFactory.getLogger(SineFitInteractor.class);
    private static final int MIN_POINTS_SELECTED = 1;
    private static final int DEFAULT_CALC_POINTS = 400;
    private Action sineFitAction = new SineFitAction();
    private Action clearFitAction = new ClearFitAction();
    private JButton[] toolBarButtons;
    private JButton btnSineFit;

    public SineFitInteractor() {
        this.createToolBarButtons();
    }

    private void createSineFit() {
        List<DisplayPoint> selectedPoints = this.getSelectedDataPoints();
        if (selectedPoints.size() < 1) {
            logger.warn("Not enough datapoints selected (min 1), aborting fit.");
            return;
        }
        SineFit fit = new SineFit(selectedPoints);
        fit.doFit();
        this.setFitToChart(fit);
    }

    private List<DisplayPoint> getSelectedDataPoints() {
        DisplayPoint[] displayPoints = this.getSelectedDisplayPoints();
        ArrayList<DisplayPoint> list = new ArrayList<DisplayPoint>();
        for (int i = 0; i < displayPoints.length; ++i) {
            list.add(displayPoints[i]);
        }
        return list;
    }

    private void setFitToChart(DataViewerFit fit) {
        DataRange range = this.getChart().getDataWindow().getXRange();
        this.setFitDataSet(fit.getResultDataSet(range, 400));
    }

    protected abstract void setFitDataSet(DataSet var1);

    protected abstract void clearFit();

    private void createToolBarButtons() {
        this.btnSineFit = new JButton(this.sineFitAction);
        this.btnSineFit.setText(null);
        this.toolBarButtons = new JButton[]{this.btnSineFit};
    }

    public Component[] getToolBarComponents() {
        return this.toolBarButtons;
    }

    public Action[] getPopupActions() {
        return new Action[]{this.sineFitAction, this.clearFitAction};
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.toolBarButtons != null && !active) {
            this.toolBarButtons[0].setEnabled(active);
        }
    }

    public class ClearFitAction
    extends AbstractAction {
        private static final long serialVersionUID = -6375357705542370646L;

        public ClearFitAction() {
            super("clear fit");
            super.putValue("ShortDescription", "<html><center><b>clear fit</b></center>Usage:<br/>use this button to remove the fit line from the dataviewer. </html>");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SineFitInteractor.this.clearFit();
        }
    }

    public class SineFitAction
    extends AbstractAction {
        private static final long serialVersionUID = -645526133743397868L;

        public SineFitAction() {
            super("Sine fit", Icon.SINE_FIT.getImageIcon());
            super.putValue("ShortDescription", "<html><center><b>Sine fit</b></center>Usage:<br/>To create a sine fit - select points to use as fit - input select <br/>them using left mouse button and click this button.</html>");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SineFitInteractor.this.createSineFit();
        }
    }
}

