/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import Jama.Matrix;
import cern.jdve.data.AbstractDataSet3D;
import cern.jdve.data.DataSet;
import cern.jdve.event.DataSetEvent;
import cern.jdve.utils.DataRange;
import java.util.ArrayList;
import java.util.List;

public class MatrixDataSet
extends AbstractDataSet3D {
    private Matrix matrix = null;
    private List<String> rowLabels = new ArrayList<String>();
    private List<String> columnLabels = new ArrayList<String>();
    boolean transposed = false;

    public MatrixDataSet(String name, Matrix matrix) {
        super(name);
        this.matrix = matrix;
    }

    public MatrixDataSet(String name, Matrix matrix, boolean transposed) {
        super(name);
        this.matrix = matrix;
        this.transposed = transposed;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
        this.fireDataSetChanged(new DataSetEvent((DataSet)this, 4));
    }

    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
        this.fireDataSetChanged(new DataSetEvent((DataSet)this, 4));
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public String getDataLabel(int index) {
        return "Index " + index;
    }

    public int getXDataCount() {
        if (this.matrix == null) {
            return 1;
        }
        if (this.transposed) {
            return this.matrix.getRowDimension();
        }
        return this.matrix.getColumnDimension();
    }

    public int getYDataCount() {
        if (this.matrix == null) {
            return 1;
        }
        if (this.transposed) {
            return this.matrix.getColumnDimension();
        }
        return this.matrix.getRowDimension();
    }

    private boolean isLimitsOk(int xIndex, int yIndex) {
        if (xIndex < 0 || yIndex < 0) {
            return false;
        }
        if (this.transposed) {
            return xIndex < this.matrix.getRowDimension() && yIndex < this.matrix.getColumnDimension();
        }
        return xIndex < this.matrix.getColumnDimension() && yIndex < this.matrix.getRowDimension();
    }

    public double getZ(int xIndex, int yIndex) {
        if (this.matrix == null || !this.isLimitsOk(xIndex, yIndex)) {
            return 0.0;
        }
        if (this.transposed) {
            return this.matrix.get(xIndex, yIndex);
        }
        return this.matrix.get(yIndex, xIndex);
    }

    public DataRange getZRange() {
        return this.calcZRange();
    }

    public double getX(int index) {
        return index;
    }

    public DataRange getXRange() {
        if (this.matrix == null) {
            return new DataRange(0.0, 0.0);
        }
        if (this.transposed) {
            return new DataRange(0.0, (double)(this.matrix.getRowDimension() - 1));
        }
        return new DataRange(0.0, (double)(this.matrix.getColumnDimension() - 1));
    }

    public double getY(int index) {
        return index;
    }

    public DataRange getYRange() {
        if (this.matrix == null) {
            return new DataRange(0.0, 0.0);
        }
        if (this.transposed) {
            return new DataRange(0.0, (double)(this.matrix.getColumnDimension() - 1));
        }
        return new DataRange(0.0, (double)(this.matrix.getRowDimension() - 1));
    }

    public int indexOf(double coordinate) {
        return new Double(coordinate).intValue();
    }

    public boolean isEditable() {
        return false;
    }

    private DataRange calcZRange() {
        if (this.matrix == null) {
            return new DataRange(0.0, 0.0);
        }
        double minZ = 0.0;
        double maxZ = 0.0;
        for (int i = 0; i < this.matrix.getRowDimension(); ++i) {
            for (int j = 0; j < this.matrix.getColumnDimension(); ++j) {
                double value = this.matrix.get(i, j);
                if (i == 0 && j == 0) {
                    minZ = value;
                    maxZ = value;
                    continue;
                }
                minZ = Math.min(minZ, value);
                maxZ = Math.max(maxZ, value);
            }
        }
        return new DataRange(minZ, maxZ);
    }

    public void setRowLabels(List<String> labels) {
        this.rowLabels = labels;
    }

    public void setColumnLabels(List<String> labels) {
        this.columnLabels = labels;
    }

    public String getXLabel(int xIndex) {
        List<String> labels = null;
        labels = this.transposed ? this.rowLabels : this.columnLabels;
        if (xIndex < labels.size()) {
            return labels.get(xIndex);
        }
        return null;
    }

    public String getYLabel(int yIndex) {
        List<String> labels = null;
        labels = this.transposed ? this.columnLabels : this.rowLabels;
        if (yIndex < labels.size()) {
            return labels.get(yIndex);
        }
        return null;
    }

    public int getColumnNumber(int xIndex, int yIndex) {
        if (this.getXRange().contains((double)xIndex) && this.getYRange().contains((double)yIndex)) {
            if (this.transposed) {
                return yIndex;
            }
            return xIndex;
        }
        return 0;
    }

    public int getRowNumber(int xIndex, int yIndex) {
        if (this.getXRange().contains((double)xIndex) && this.getYRange().contains((double)yIndex)) {
            if (this.transposed) {
                return xIndex;
            }
            return yIndex;
        }
        return 0;
    }

    public String getRowLabel(int row) {
        if (row >= 0 && row < this.rowLabels.size()) {
            return this.rowLabels.get(row);
        }
        return null;
    }

    public String getColumnLabel(int column) {
        if (column >= 0 && column < this.columnLabels.size()) {
            return this.columnLabels.get(column);
        }
        return null;
    }

    public void set(int index, int index2, double x, double y, double z) {
        throw new UnsupportedOperationException("not implemented");
    }
}

