/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import cern.accsoft.steering.util.gui.dv.ds.ErrorDataSet;
import cern.accsoft.steering.util.gui.dv.ds.ValidityDataSet;
import cern.jdve.data.AbstractDataSet;
import cern.jdve.data.DataSet;
import cern.jdve.data.DataSource;
import cern.jdve.data.DefaultDataSource;

public class ErrorDataSetAdapter
extends AbstractDataSet
implements ValidityDataSet,
DataSet {
    private ErrorDataSet delegate;
    private ErrorAddMode errorAddMode = ErrorAddMode.OFF;

    public ErrorDataSetAdapter(ErrorDataSet delegate, ErrorAddMode errorAddMode) {
        super(delegate.getName() + "-error (" + errorAddMode.toString() + ")");
        this.delegate = delegate;
        this.errorAddMode = errorAddMode;
    }

    public double getY(int index) {
        double value = this.delegate.getY(index);
        Double errorValue = this.delegate.getYError(index);
        if (errorValue != null) {
            if (ErrorAddMode.PLUS.equals((Object)this.errorAddMode)) {
                value += errorValue.doubleValue();
            } else if (ErrorAddMode.MINUS.equals((Object)this.errorAddMode)) {
                value -= errorValue.doubleValue();
            }
        }
        return value;
    }

    @Override
    public boolean getValidity(int index) {
        return this.delegate.getValidity(index);
    }

    @Override
    public boolean hasValidityInformation() {
        return this.delegate.hasValidityInformation();
    }

    public void add(int index, double x, double y) {
        this.delegate.add(index, x, y);
    }

    public int getDataCount() {
        return this.delegate.getDataCount();
    }

    public double getX(int index) {
        return this.delegate.getX(index);
    }

    public void remove(int fromIndex, int toIndex) {
        this.delegate.remove(fromIndex, toIndex);
    }

    public static final DataSource createDefaultErrorDataSource(ErrorDataSet dataSet) {
        return new DefaultDataSource(new DataSet[]{new ErrorDataSetAdapter(dataSet, ErrorAddMode.PLUS), new ErrorDataSetAdapter(dataSet, ErrorAddMode.MINUS)});
    }

    public static enum ErrorAddMode {
        PLUS,
        MINUS,
        OFF;

    }
}

