/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dialog;

import cern.accsoft.steering.util.gui.panels.Applyable;
import cern.accsoft.steering.util.gui.panels.PanelProvider;
import cern.accsoft.steering.util.gui.panels.Titleable;
import cern.accsoft.steering.util.gui.panels.ValidateApplyable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelDialog
extends JDialog {
    private static final long serialVersionUID = 67399462987558666L;
    private static final Logger logger = LoggerFactory.getLogger(PanelDialog.class);
    private Object content;
    private JPanel panel;
    private boolean ok = false;

    private PanelDialog(Object content, Frame parentFrame, boolean modal) {
        super(parentFrame, modal);
        this.content = content;
        if (this.getContent() instanceof JPanel) {
            this.setPanel((JPanel)this.getContent());
        } else if (this.getContent() instanceof PanelProvider) {
            this.setPanel(((PanelProvider)this.getContent()).getPanel());
        } else {
            logger.error("can not add content of type '" + this.getContent().getClass().getName() + "' to contentPane!");
        }
        this.initComponents();
    }

    private static final boolean showContent(Object content, Frame parentFrame, boolean modal) {
        PanelDialog dialog = new PanelDialog(content, parentFrame, modal);
        dialog.setVisible(true);
        return dialog.isOk();
    }

    public static final boolean show(JPanel panel, Frame parentFrame) {
        return PanelDialog.showContent(panel, parentFrame, true);
    }

    public static final boolean show(JPanel panel, Frame parentFrame, boolean modal) {
        return PanelDialog.showContent(panel, parentFrame, modal);
    }

    public static final boolean show(PanelProvider panelProvider, Frame parentFrame) {
        return PanelDialog.showContent(panelProvider, parentFrame, true);
    }

    public static final boolean show(PanelProvider panelProvider, Frame parentFrame, boolean modal) {
        return PanelDialog.showContent(panelProvider, parentFrame, modal);
    }

    private void initComponents() {
        String title = "User input";
        if (this.getPanel() instanceof Titleable) {
            title = ((Titleable)((Object)this.getPanel())).getTitle();
        }
        this.setTitle(title);
        if (this.isModal()) {
            this.setDefaultCloseOperation(0);
        }
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.getPanel(), "Center");
        JPanel buttonPanel = new JPanel();
        if (this.isModal()) {
            buttonPanel.add(new JButton(this.createOkAction()));
            buttonPanel.add(new JButton(this.createCancelAction()));
        } else {
            buttonPanel.add(new JButton(this.createCloseAction()));
        }
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    private Action createCancelAction() {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = -8624416405029781753L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelDialog.this.cancel();
                PanelDialog.this.setVisible(false);
            }
        };
        action.putValue("Name", "Cancel");
        action.putValue("ShortDescription", "Closes dialog without applying changes.");
        return action;
    }

    private Action createOkAction() {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = -8624416405029781753L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean doIt = true;
                if (PanelDialog.this.getContent() instanceof ValidateApplyable) {
                    doIt = ((ValidateApplyable)PanelDialog.this.getContent()).prepareApply();
                }
                if (doIt) {
                    PanelDialog.this.apply();
                    PanelDialog.this.setVisible(false);
                }
            }
        };
        action.putValue("Name", "Ok");
        action.putValue("ShortDescription", "Saves changes and closes dialog.");
        return action;
    }

    private Action createCloseAction() {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = -8624416405029781753L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelDialog.this.setVisible(false);
            }
        };
        action.putValue("Name", "Close");
        action.putValue("ShortDescription", "Closes the dialog.");
        return action;
    }

    private void apply() {
        if (this.getContent() instanceof Applyable) {
            this.ok = ((Applyable)this.getContent()).apply();
        }
        this.ok = true;
    }

    private void cancel() {
        if (this.getContent() instanceof Applyable) {
            ((Applyable)this.getContent()).cancel();
        }
        this.ok = false;
    }

    private Object getContent() {
        return this.content;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void setPanel(JPanel panel) {
        this.panel = panel;
    }

    private JPanel getPanel() {
        return this.panel;
    }
}

