/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels.var;

import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.gui.panels.var.AbstractVarSelectionTableModel;
import cern.accsoft.steering.jmad.gui.panels.var.SelectedVarManager;
import cern.accsoft.steering.jmad.gui.panels.var.SelectedVarManagerImpl;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import cern.accsoft.steering.util.table.RadioColumnEditor;
import cern.accsoft.steering.util.table.RadioColumnRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class VarSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 2433227096109178284L;
    static final Dimension PREFERRED_TABLE_SIZE = new Dimension(200, 400);
    private SelectedVarManager selectedVarManager = new SelectedVarManagerImpl();
    private TwissVariable defaultVariable = null;
    private JTable table;
    private AbstractVarSelectionTableModel tableModel;

    public void init() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        this.getTableModel().setShowSelectColumn(true);
        this.getTableModel().setSelectedVarManager(this.getSelectedVarManager());
        this.table = new JTable(this.getTableModel());
        this.table.setAutoCreateRowSorter(true);
        this.add((Component)new TableFilterPanel(this.table), constraints);
        this.table.setSelectionMode(0);
        TableColumn selectColumn = this.table.getColumnModel().getColumn(0);
        selectColumn.setPreferredWidth(50);
        if (SelectedVarManager.VarSelectionMode.SINGLE == this.getSelectedVarManager().getVarSelectionMode()) {
            selectColumn.setCellRenderer(new RadioColumnRenderer());
            selectColumn.setCellEditor(new RadioColumnEditor());
        }
        if (this.getDefaultVariable() != null) {
            for (int i = 0; i < this.getTableModel().getAvailableVariables().size(); ++i) {
                TwissVariable var = this.getTableModel().getAvailableVariables().get(i);
                if (!this.getDefaultVariable().equals(var)) continue;
                this.getTableModel().setValueAt(true, i, 0);
            }
        }
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        scrollPane.setPreferredSize(PREFERRED_TABLE_SIZE);
        this.add((Component)scrollPane, constraints);
        this.validate();
    }

    public void setTableModel(AbstractVarSelectionTableModel tableModel) {
        this.tableModel = tableModel;
    }

    private AbstractVarSelectionTableModel getTableModel() {
        return this.tableModel;
    }

    public TwissVariable getDefaultVariable() {
        return this.defaultVariable;
    }

    public void setDefaultVariable(TwissVariable defaultVariable) {
        this.defaultVariable = defaultVariable;
    }

    public void setSelectedVarManager(SelectedVarManager selectedVarManager) {
        this.selectedVarManager = selectedVarManager;
    }

    private SelectedVarManager getSelectedVarManager() {
        return this.selectedVarManager;
    }
}

