/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels.var;

import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.domain.var.VariableUtil;
import cern.accsoft.steering.jmad.gui.panels.var.AbstractVarSelectionTableModel;
import cern.accsoft.steering.jmad.util.MadxVarType;
import java.util.ArrayList;
import java.util.List;

public class GenericTwissVarSelectionTableModel<T extends Enum<T>>
extends AbstractVarSelectionTableModel {
    private static final long serialVersionUID = -4113863768028872933L;
    private final List<T> availableVariables;
    private int columnCount;
    private int colidxName;

    public GenericTwissVarSelectionTableModel(Class<T> clazz) {
        this.columnCount = this.axesCount + 1;
        this.colidxName = this.columnCount - 1;
        this.updateColumnCounts();
        this.availableVariables = new ArrayList<T>(VariableUtil.findFromVarType(clazz, (MadxVarType)MadxVarType.DOUBLE));
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.getAvailableVariables().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        TwissVariable variable = this.getAvailableVariables().get(row);
        if (col >= 0 & col < this.axesCount) {
            return this.getSelectedVarManager().getSelectedVariables().contains(variable);
        }
        if (col == this.colidxName) {
            return variable.toString();
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col >= 0 & col < this.axesCount) {
            return Boolean.class;
        }
        if (col == this.colidxName) {
            return String.class;
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        if (col >= 0 & col < this.axesCount) {
            return "plot";
        }
        if (col == this.colidxName) {
            return "variable";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 0 & col < this.axesCount;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TwissVariable variable = this.getAvailableVariables().get(row);
        if (col >= 0 & col < this.axesCount) {
            if (((Boolean)value).booleanValue()) {
                this.getSelectedVarManager().add(variable);
            } else {
                this.getSelectedVarManager().remove(variable);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    protected void updateColumnCounts() {
        this.columnCount = this.axesCount + 1;
        this.colidxName = this.columnCount - 1;
    }

    @Override
    public List<? extends TwissVariable> getAvailableVariables() {
        return this.availableVariables;
    }
}

