/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.gui.executor.ActiveJobsEvent;
import com.google.common.collect.ImmutableMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.springframework.context.event.EventListener;

public class GuiLogPanel
extends JPanel {
    private static final String SHOW_LOGS = "Show logs";
    private static final String HIDE_LOGS = "Hide logs";
    private static final int EXPANDED_HEIGHT = 300;
    private static final int CLOSED_HEIGHT = 0;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private final GuiLogAppender guiLogAppender;
    private final AtomicBoolean isExpanded = new AtomicBoolean(false);
    private final JLabel activeJobsLabel;

    public GuiLogPanel() {
        this.setLayout(new BorderLayout());
        JTextPane fullLogText = new JTextPane();
        fullLogText.setEditable(false);
        JTextField lastEventText = new JTextField();
        lastEventText.setEditable(false);
        JScrollPane fullLogPane = new JScrollPane(fullLogText);
        JButton showLogsButton = new JButton(SHOW_LOGS);
        showLogsButton.setPreferredSize(new Dimension(120, showLogsButton.getPreferredSize().height));
        showLogsButton.addActionListener(c -> {
            if (this.isExpanded.get()) {
                GuiLogPanel.setHeight(fullLogPane, 0);
                showLogsButton.setText(SHOW_LOGS);
            } else {
                GuiLogPanel.setHeight(fullLogPane, 300);
                showLogsButton.setText(HIDE_LOGS);
            }
            this.isExpanded.set(!this.isExpanded.get());
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            frame.pack();
        });
        GuiLogPanel.setHeight(fullLogPane, 0);
        this.activeJobsLabel = new JLabel();
        this.activeJobsLabel.setPreferredSize(new Dimension(120, this.activeJobsLabel.getPreferredSize().height));
        this.activeJobsLabel.setBackground(DEFAULT_BACKGROUND_COLOR);
        JPanel southBar = new JPanel();
        southBar.setLayout(new BoxLayout(southBar, 0));
        southBar.setBackground(DEFAULT_BACKGROUND_COLOR);
        southBar.add(lastEventText);
        southBar.add(this.activeJobsLabel);
        southBar.add(showLogsButton);
        this.add((Component)fullLogPane, "North");
        this.add((Component)southBar, "South");
        this.guiLogAppender = new GuiLogAppender(lastEventText, fullLogText);
    }

    public void init() {
        this.setActiveJobText(0);
    }

    @EventListener
    public void activeJobsCountChanged(ActiveJobsEvent e) {
        SwingUtilities.invokeLater(() -> this.setActiveJobText(e.getActiveJobsCount()));
    }

    private void setActiveJobText(int activeJobs) {
        this.activeJobsLabel.setText(GuiLogPanel.formatActiveJobsCount(activeJobs));
        this.activeJobsLabel.setForeground(GuiLogPanel.backgroundForActiveJobsCount(activeJobs));
    }

    private static Color backgroundForActiveJobsCount(int activeJobs) {
        if (activeJobs == 0) {
            return Color.GRAY;
        }
        return Color.BLUE.brighter();
    }

    private static String formatActiveJobsCount(int count) {
        if (count == 0) {
            return "No active jobs";
        }
        return String.format("Active jobs: %2d", count);
    }

    private static void setHeight(JScrollPane fullLogPane, int closedHeight) {
        fullLogPane.setPreferredSize(new Dimension(fullLogPane.getWidth(), closedHeight));
        fullLogPane.setSize(new Dimension(fullLogPane.getWidth(), closedHeight));
    }

    public Appender getGuiLogAppender() {
        return this.guiLogAppender;
    }

    public static class GuiLogAppender
    extends AppenderSkeleton {
        private static final Map<Level, Color> LEVEL_STATUS_COLOR = ImmutableMap.of((Object)Level.ERROR, (Object)Color.RED, (Object)Level.INFO, (Object)Color.GREEN, (Object)Level.WARN, (Object)Color.ORANGE);
        private static final Map<Level, Color> LEVEL_TEXT_COLOR = ImmutableMap.of((Object)Level.ERROR, (Object)Color.RED, (Object)Level.INFO, (Object)Color.BLUE, (Object)Level.WARN, (Object)Color.ORANGE.darker());
        private static final int BACKGROUND_RESET_TIMEOUT_MS = 4000;
        private final JTextField lastEventPane;
        private final JTextPane fullEventPane;
        private final Timer lastEventBackgroundResetTime;
        private final Map<Level, Style> levelStyles;
        private final Style defaultStyle;

        GuiLogAppender(JTextField lastEventPane, JTextPane fullEventPane) {
            super(true);
            this.lastEventPane = lastEventPane;
            this.fullEventPane = fullEventPane;
            ImmutableMap.Builder levelStyleBuilder = ImmutableMap.builder();
            LEVEL_TEXT_COLOR.forEach((level, color) -> {
                Style style = fullEventPane.addStyle(level.toString(), null);
                StyleConstants.setForeground(style, color);
                levelStyleBuilder.put(level, (Object)style);
            });
            this.levelStyles = levelStyleBuilder.build();
            Style style = fullEventPane.addStyle("DEFAULT", null);
            StyleConstants.setForeground(style, Color.BLACK);
            this.defaultStyle = style;
            lastEventPane.setBorder(BorderFactory.createEmptyBorder());
            this.setThreshold((Priority)Level.INFO);
            this.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %-5p [%t]: %m %n"));
            this.lastEventBackgroundResetTime = new Timer(4000, a -> lastEventPane.setBackground(DEFAULT_BACKGROUND_COLOR));
        }

        protected void append(LoggingEvent event) {
            String msg = this.layout.format(event);
            String exceptionInfo = Optional.ofNullable(event.getThrowableStrRep()).map(lines -> String.join((CharSequence)"\n", lines)).orElse("");
            Level level = event.getLevel();
            SwingUtilities.invokeLater(() -> {
                this.lastEventBackgroundResetTime.restart();
                this.lastEventPane.setText(msg);
                Document document = this.fullEventPane.getDocument();
                try {
                    document.insertString(document.getLength(), msg + exceptionInfo, this.levelStyles.getOrDefault(level, this.defaultStyle));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.lastEventPane.setBackground(LEVEL_STATUS_COLOR.getOrDefault(level, DEFAULT_BACKGROUND_COLOR));
            });
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

