/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.result.tfs.TfsResult;
import cern.accsoft.steering.jmad.domain.result.tfs.TfsSummary;
import cern.accsoft.steering.jmad.gui.panels.AbstractTfsDataSetManagerResultPanel;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TfsSummaryPanel
extends AbstractTfsDataSetManagerResultPanel {
    private static final long serialVersionUID = 1L;
    private TfsSummaryTableModel tableModel = new TfsSummaryTableModel();

    public void init() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JTable table = new JTable(this.tableModel);
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        this.add((Component)new TableFilterPanel(table), "North");
        this.add((Component)scrollPane, "Center");
        this.validate();
    }

    @Override
    protected void update(TfsResult tfsResult) {
        this.tableModel.setTfsSummary(tfsResult.getSummary());
    }

    static class TfsSummaryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private TfsSummary tfsSummary;
        private List<String> keys = new ArrayList<String>();
        private static final int COL_IDX_NAME = 0;
        private static final int COL_IDX_VALUE = 1;
        private static final int COL_COUNT = 2;

        TfsSummaryTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.tfsSummary != null) {
                return this.keys.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "name";
            }
            if (col == 1) {
                return "value";
            }
            return super.getColumnName(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            String key = this.keys.get(row);
            if (col == 0) {
                return key;
            }
            if (col == 1) {
                return this.tfsSummary.getStringValue(key);
            }
            return null;
        }

        public void setTfsSummary(TfsSummary tfsSummary) {
            this.tfsSummary = tfsSummary;
            this.keys = new ArrayList<String>(tfsSummary.getKeys());
            this.fireTableDataChanged();
        }
    }
}

