/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.domain.machine.RangeDefinition;
import cern.accsoft.steering.jmad.domain.machine.SequenceDefinition;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import cern.accsoft.steering.util.gui.panels.Applyable;
import cern.accsoft.steering.util.gui.panels.Titleable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSelectionPanel
extends JPanel
implements Titleable,
Applyable {
    private static final Logger logger = LoggerFactory.getLogger(RangeSelectionPanel.class);
    private static final long serialVersionUID = -3095464304653777882L;
    private JMadModelManager modelManager;
    private JComboBox cboSequence;
    private JComboBox cboRange;
    private ActionListener rangeComboListener;
    private ActionListener sequenceComboListener;
    private JMadModelDefinition activeModelDefinition = null;

    public void init() {
        this.initComponenets();
    }

    private void initComponenets() {
        JMadModel model;
        this.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel(new GridBagLayout());
        this.add((Component)comboPanel, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        comboPanel.add((Component)new JLabel("Sequence: "), constraints);
        ++constraints.gridx;
        this.cboSequence = new JComboBox();
        comboPanel.add((Component)this.cboSequence, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        comboPanel.add((Component)new JLabel("Range: "), constraints);
        ++constraints.gridx;
        this.cboRange = new JComboBox();
        comboPanel.add((Component)this.cboRange, constraints);
        if (this.modelManager != null && (model = this.modelManager.getActiveModel()) != null) {
            this.setActiveModel(model);
        }
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel model) {
                RangeSelectionPanel.this.setActiveModel(model);
            }
        });
    }

    void setActiveModelDefinition(JMadModelDefinition modelDefinition, RangeDefinition rangeDefinition) {
        this.activeModelDefinition = modelDefinition;
        this.fillSequenceSelectionComboBox();
        if (rangeDefinition != null) {
            this.setActiveSequenceDefinition(rangeDefinition.getSequenceDefinition());
            this.setActiveRangeDefinition(rangeDefinition);
        }
    }

    void setActiveModel(JMadModel model) {
        if (model == null) {
            this.setActiveModelDefinition(null, null);
        } else {
            this.setActiveModelDefinition(model.getModelDefinition(), model.getActiveRangeDefinition());
        }
    }

    private void setActiveSequenceDefinition(SequenceDefinition sequenceDefinition) {
        this.cboSequence.setSelectedItem(sequenceDefinition);
        this.fillRangeSelectionComboBox();
    }

    private SequenceDefinition getActiveSequenceDefinition() {
        return (SequenceDefinition)this.cboSequence.getSelectedItem();
    }

    private void setActiveRangeDefinition(RangeDefinition rangeDefinition) {
        this.cboRange.setSelectedItem(rangeDefinition);
    }

    RangeDefinition getActiveRangeDefinition() {
        return (RangeDefinition)this.cboRange.getSelectedItem();
    }

    private void fillSequenceSelectionComboBox() {
        this.cboSequence.removeActionListener(this.getSequenceComboListener());
        this.cboSequence.removeAllItems();
        if (this.getActiveModelDefinition() == null) {
            return;
        }
        for (SequenceDefinition sequenceDefinition : this.getActiveModelDefinition().getSequenceDefinitions()) {
            this.cboSequence.addItem(sequenceDefinition);
        }
        this.cboSequence.setSelectedItem(this.getActiveModelDefinition().getDefaultSequenceDefinition());
        this.cboSequence.addActionListener(this.getSequenceComboListener());
    }

    private JMadModelDefinition getActiveModelDefinition() {
        return this.activeModelDefinition;
    }

    private void fillRangeSelectionComboBox() {
        this.cboRange.removeActionListener(this.getRangeComboListener());
        this.cboRange.removeAllItems();
        for (RangeDefinition rangeDefinition : this.getActiveSequenceDefinition().getRangeDefinitions()) {
            this.cboRange.addItem(rangeDefinition);
        }
        this.cboRange.setSelectedItem(this.getActiveSequenceDefinition().getDefaultRangeDefinition());
        this.cboRange.addActionListener(this.getRangeComboListener());
    }

    private ActionListener getSequenceComboListener() {
        if (this.sequenceComboListener == null) {
            this.sequenceComboListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RangeSelectionPanel.this.fillRangeSelectionComboBox();
                }
            };
        }
        return this.sequenceComboListener;
    }

    private ActionListener getRangeComboListener() {
        if (this.rangeComboListener == null) {
            this.rangeComboListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
        return this.rangeComboListener;
    }

    @Override
    public String getTitle() {
        return "Range selection";
    }

    @Override
    public boolean apply() {
        JMadModel model = this.modelManager.getActiveModel();
        if (model == null) {
            return false;
        }
        RangeDefinition rangeDefinition = this.getActiveRangeDefinition();
        if (rangeDefinition == null) {
            return false;
        }
        try {
            model.setActiveRangeDefinition(rangeDefinition);
            return true;
        }
        catch (JMadModelException e) {
            logger.error("Error while setting range '" + rangeDefinition.getName() + "' Model.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void cancel() {
    }
}

