/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.domain.var.enums.MadxTwissVariable;
import cern.accsoft.steering.jmad.gui.data.TfsResultDataSet;
import cern.accsoft.steering.jmad.gui.manage.TfsDataSetManager;
import cern.accsoft.steering.jmad.gui.panels.var.AllVarSelectionPanel;
import cern.accsoft.steering.jmad.gui.panels.var.SelectedVarManager;
import cern.accsoft.steering.jmad.gui.panels.var.SelectedVarManagerImpl;
import cern.accsoft.steering.util.gui.panels.Applyable;
import cern.accsoft.steering.util.gui.panels.Titleable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.TabbedPaneUI;

public abstract class PlotCreationPanel
extends JPanel
implements Titleable,
Applyable {
    private static final long serialVersionUID = -8324977554578482096L;
    private static final int MAX_Y_PANELS = 9;
    private TfsDataSetManager tfsDataSetManager = null;
    private JTextField txtName = null;
    private JComboBox cboTfsDataSetType = null;
    private JTabbedPane varSelTabPane = null;
    private AllVarSelectionPanel xPanel = null;
    private List<AllVarSelectionPanel> yPanels = new ArrayList<AllVarSelectionPanel>();
    private JPanel newYPanel = new JPanel();
    private JPanel delLastYPanel = new JPanel();

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 300));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        JLabel label = new JLabel("Name:");
        this.add((Component)label, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        this.txtName = new JTextField();
        this.txtName.setToolTipText("The name of the new chart.");
        this.add((Component)this.txtName, constraints);
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        this.cboTfsDataSetType = new JComboBox<TfsResultDataSet.TfsResultDataSetType>(TfsResultDataSet.TfsResultDataSetType.values());
        this.cboTfsDataSetType.setSelectedItem((Object)TfsResultDataSet.TfsResultDataSetType.ABSOLUTE);
        this.cboTfsDataSetType.setToolTipText("Selects the type of datasat (absolute, relative ...)");
        this.add((Component)this.cboTfsDataSetType, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.varSelTabPane = new JTabbedPane();
        this.varSelTabPane.setTabPlacement(2);
        this.add((Component)this.varSelTabPane, constraints);
        this.xPanel = this.createAnotherVariableSelectionPanel(SelectedVarManager.VarSelectionMode.SINGLE, (TwissVariable)MadxTwissVariable.S);
        this.varSelTabPane.addTab("x", this.xPanel);
        AllVarSelectionPanel yPanel = this.createAnotherVariableSelectionPanel(SelectedVarManager.VarSelectionMode.MULTIPLE, null);
        this.yPanels.add(yPanel);
        this.varSelTabPane.addTab("y", yPanel);
        this.varSelTabPane.addTab("+", this.newYPanel);
        this.varSelTabPane.setSelectedComponent(yPanel);
        this.varSelTabPane.addMouseListener(new MouseAdapter(){
            private Boolean editing = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                Boolean bl = this.editing;
                synchronized (bl) {
                    if (this.editing.booleanValue()) {
                        return;
                    }
                }
                this.editing = true;
                TabbedPaneUI ui = PlotCreationPanel.this.varSelTabPane.getUI();
                int tab = ui.tabForCoordinate(PlotCreationPanel.this.varSelTabPane, e.getX(), e.getY());
                if (tab >= 0) {
                    JComponent selectedComponent = (JComponent)PlotCreationPanel.this.varSelTabPane.getComponentAt(tab);
                    if (selectedComponent == PlotCreationPanel.this.newYPanel) {
                        PlotCreationPanel.this.addRemoveYPanel(true);
                    } else if (selectedComponent == PlotCreationPanel.this.delLastYPanel) {
                        PlotCreationPanel.this.addRemoveYPanel(false);
                    }
                }
                Boolean bl2 = this.editing;
                synchronized (bl2) {
                    this.editing = false;
                }
            }
        });
    }

    private void addRemoveYPanel(boolean add) {
        this.varSelTabPane.remove(this.newYPanel);
        this.varSelTabPane.remove(this.delLastYPanel);
        AllVarSelectionPanel yPanel = null;
        if (add) {
            if (this.yPanels.size() == 1) {
                this.varSelTabPane.removeTabAt(this.varSelTabPane.getTabCount() - 1);
                this.varSelTabPane.addTab("y1", this.yPanels.get(0));
            }
            yPanel = this.createAnotherVariableSelectionPanel(SelectedVarManager.VarSelectionMode.MULTIPLE, null);
            this.yPanels.add(yPanel);
            this.varSelTabPane.addTab("y" + this.yPanels.size(), yPanel);
        } else {
            this.yPanels.remove(this.yPanels.size() - 1);
            this.varSelTabPane.removeTabAt(this.varSelTabPane.getTabCount() - 1);
            if (this.yPanels.size() == 1) {
                this.varSelTabPane.removeTabAt(this.varSelTabPane.getTabCount() - 1);
                this.varSelTabPane.addTab("y", this.yPanels.get(0));
            }
        }
        if (this.yPanels.size() > 1) {
            this.varSelTabPane.addTab("-", this.delLastYPanel);
        }
        if (this.yPanels.size() < 9) {
            this.varSelTabPane.addTab("+", this.newYPanel);
        }
        if (yPanel != null) {
            this.varSelTabPane.setSelectedComponent(yPanel);
        }
        this.validate();
    }

    private AllVarSelectionPanel createAnotherVariableSelectionPanel(SelectedVarManager.VarSelectionMode varSelectionMode, TwissVariable defaultVariable) {
        SelectedVarManagerImpl selectedVarManager = new SelectedVarManagerImpl();
        selectedVarManager.setVarSelectionMode(varSelectionMode);
        AllVarSelectionPanel panel = this.createVariableSelectionPanel();
        panel.setSelectedVarManager(selectedVarManager);
        panel.setDefaultVariable(defaultVariable);
        panel.init();
        return panel;
    }

    protected abstract AllVarSelectionPanel createVariableSelectionPanel();

    public void setTfsDataSetManager(TfsDataSetManager tfsDataSetManager) {
        this.tfsDataSetManager = tfsDataSetManager;
    }

    public TfsDataSetManager getTfsDataSetManager() {
        return this.tfsDataSetManager;
    }

    @Override
    public String getTitle() {
        return "Create new chart-view";
    }

    @Override
    public boolean apply() {
        HashMap<Integer, Collection<TwissVariable>> yVars = new HashMap<Integer, Collection<TwissVariable>>();
        for (int yAxis = 0; yAxis < this.yPanels.size(); ++yAxis) {
            SelectedVarManager ySelector = this.yPanels.get(yAxis).getSelectedVarManager();
            yVars.put(yAxis, ySelector.getSelectedVariables());
        }
        this.tfsDataSetManager.createDataSets(this.txtName.getText(), this.xPanel.getSelectedVarManager().getSelectedVariable(), yVars, (TfsResultDataSet.TfsResultDataSetType)((Object)this.cboTfsDataSetType.getSelectedItem()));
        return true;
    }

    @Override
    public void cancel() {
    }
}

