/*
 * Decompiled with CFR 0.152.
 */
package io.janstenpickle.trace4cats.stackdriver;

import cats.Eval;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Show$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Async$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.syntax.package;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.trace.v2.TraceServiceClient;
import com.google.cloud.trace.v2.TraceServiceSettings;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.SpanName;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import io.janstenpickle.trace4cats.kernel.SpanExporter;
import io.janstenpickle.trace4cats.model.AttributeValue;
import io.janstenpickle.trace4cats.model.CompletedSpan;
import io.janstenpickle.trace4cats.model.SpanId;
import io.janstenpickle.trace4cats.model.SpanId$;
import io.janstenpickle.trace4cats.model.SpanKind;
import io.janstenpickle.trace4cats.model.SpanStatus;
import io.janstenpickle.trace4cats.model.TraceId;
import io.janstenpickle.trace4cats.model.TraceId$;
import io.janstenpickle.trace4cats.stackdriver.common.TruncatableString;
import io.janstenpickle.trace4cats.stackdriver.common.TruncatableString$;
import java.io.Serializable;
import java.time.Instant;
import org.threeten.bp.Duration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class StackdriverGrpcSpanExporter$
implements Serializable {
    public static final StackdriverGrpcSpanExporter$ MODULE$ = new StackdriverGrpcSpanExporter$();

    private StackdriverGrpcSpanExporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StackdriverGrpcSpanExporter$.class);
    }

    public <F, G> Resource<F, SpanExporter<F, G>> apply(String projectId, Option<Credentials> credentials, FiniteDuration requestTimeout, Async<F> evidence$1, Foldable<G> evidence$2) {
        ProjectName projectName = ProjectName.of((String)projectId);
        Object traceClient = Sync$.MODULE$.apply(evidence$1).delay(() -> this.$anonfun$1(credentials, requestTimeout));
        return Resource$.MODULE$.make(traceClient, (Function1 & Serializable)client -> Sync$.MODULE$.apply((Sync)evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.apply$$anonfun$3$$anonfun$1(client))), evidence$1).map((Function1 & Serializable)client -> new SpanExporter<F, G>(projectId, evidence$1, evidence$2, projectName, (TraceServiceClient)client){
            private final String projectId$1;
            private final Async evidence$1$1;
            private final Foldable evidence$2$1;
            private final ProjectName projectName$1;
            private final TraceServiceClient client$1;
            {
                this.projectId$1 = projectId$6;
                this.evidence$1$1 = evidence$1$8;
                this.evidence$2$1 = evidence$2$4;
                this.projectName$1 = projectName$4;
                this.client$1 = client$5;
            }

            public Object exportBatch(Object batch) {
                return StackdriverGrpcSpanExporter$.MODULE$.io$janstenpickle$trace4cats$stackdriver$StackdriverGrpcSpanExporter$$$_$write$6(this.projectId$1, this.evidence$1$1, this.evidence$2$1, this.projectName$1, this.client$1, batch);
            }
        });
    }

    public <F, G> Option<Credentials> apply$default$2() {
        return None$.MODULE$;
    }

    public <F, G> FiniteDuration apply$default$3() {
        return new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
    }

    private final GoogleCredentials $anonfun$2() {
        return GoogleCredentials.getApplicationDefault();
    }

    private final TraceServiceClient $anonfun$1(Option credentials$1, FiniteDuration requestTimeout$1) {
        Credentials creds = (Credentials)credentials$1.getOrElse(this::$anonfun$2);
        TraceServiceSettings.Builder clientBuilder = (TraceServiceSettings.Builder)TraceServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)creds));
        clientBuilder.batchWriteSpansSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)requestTimeout$1.toMillis()));
        return TraceServiceClient.create((TraceServiceSettings)clientBuilder.build());
    }

    private final com.google.devtools.cloudtrace.v2.TruncatableString toTruncatableStringProto$1(String string) {
        TruncatableString truncatableString = TruncatableString$.MODULE$.apply(string);
        return com.google.devtools.cloudtrace.v2.TruncatableString.newBuilder().setValue(truncatableString.value()).setTruncatedByteCount(truncatableString.truncatedByteCount()).build();
    }

    private final Timestamp toTimestampProto$1(Instant timestamp) {
        return Timestamp.newBuilder().setSeconds(timestamp.getEpochSecond()).setNanos(timestamp.getNano()).build();
    }

    private final String toDisplayName$1(String spanName, SpanKind spanKind) {
        SpanKind spanKind2 = spanKind;
        return SpanKind.Server$.MODULE$.equals(spanKind2) && !spanName.startsWith("Recv.") ? new StringBuilder(5).append("Recv.").append(spanName).toString() : (SpanKind.Client$.MODULE$.equals(spanKind2) && !spanName.startsWith("Sent.") ? new StringBuilder(5).append("Sent.").append(spanName).toString() : (SpanKind.Consumer$.MODULE$.equals(spanKind2) && !spanName.startsWith("Recv.") ? new StringBuilder(5).append("Recv.").append(spanName).toString() : (SpanKind.Producer$.MODULE$.equals(spanKind2) && !spanName.startsWith("Sent.") ? new StringBuilder(5).append("Sent.").append(spanName).toString() : spanName)));
    }

    private final Span.Attributes toAttributesProto$2(Map attributes) {
        return ((Span.Attributes.Builder)attributes.toList().foldLeft((Object)Span.Attributes.newBuilder(), (Function2 & Serializable)(x$1, x$2) -> {
            AttributeValue.Builder builder;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            Span.Attributes.Builder acc = (Span.Attributes.Builder)tuple2._1();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple22._1();
            io.janstenpickle.trace4cats.model.AttributeValue v = (io.janstenpickle.trace4cats.model.AttributeValue)tuple22._2();
            io.janstenpickle.trace4cats.model.AttributeValue attributeValue = v;
            if (attributeValue instanceof AttributeValue.StringValue) {
                Eval eval;
                Eval eval2 = AttributeValue.StringValue$.MODULE$.unapply(attributeValue == null ? null : ((AttributeValue.StringValue)attributeValue).value());
                Eval value = eval = AttributeValue.StringValue$.MODULE$._1$extension(eval2);
                builder = AttributeValue.newBuilder().setStringValue(this.toTruncatableStringProto$1((String)value.value()));
                return acc.putAttributeMap(k, builder.build());
            } else if (attributeValue instanceof AttributeValue.BooleanValue) {
                Eval eval;
                Eval eval3 = AttributeValue.BooleanValue$.MODULE$.unapply(attributeValue == null ? null : ((AttributeValue.BooleanValue)attributeValue).value());
                Eval value = eval = AttributeValue.BooleanValue$.MODULE$._1$extension(eval3);
                builder = AttributeValue.newBuilder().setBoolValue(BoxesRunTime.unboxToBoolean((Object)value.value()));
                return acc.putAttributeMap(k, builder.build());
            } else if (attributeValue instanceof AttributeValue.DoubleValue) {
                Eval eval;
                Eval eval4 = AttributeValue.DoubleValue$.MODULE$.unapply(attributeValue == null ? null : ((AttributeValue.DoubleValue)attributeValue).value());
                Eval value = eval = AttributeValue.DoubleValue$.MODULE$._1$extension(eval4);
                builder = AttributeValue.newBuilder().setStringValue(this.toTruncatableStringProto$1(package.show$.MODULE$.toShow(value.value(), Show$.MODULE$.catsShowForDouble()).show()));
                return acc.putAttributeMap(k, builder.build());
            } else if (attributeValue instanceof AttributeValue.LongValue) {
                Eval eval;
                Eval eval5 = AttributeValue.LongValue$.MODULE$.unapply(attributeValue == null ? null : ((AttributeValue.LongValue)attributeValue).value());
                Eval value = eval = AttributeValue.LongValue$.MODULE$._1$extension(eval5);
                builder = AttributeValue.newBuilder().setIntValue(BoxesRunTime.unboxToLong((Object)value.value()));
                return acc.putAttributeMap(k, builder.build());
            } else {
                if (!(attributeValue instanceof AttributeValue.AttributeList)) throw new MatchError((Object)attributeValue);
                AttributeValue.AttributeList vs = (AttributeValue.AttributeList)attributeValue;
                builder = AttributeValue.newBuilder().setStringValue(this.toTruncatableStringProto$1(package.show$.MODULE$.toShow((Object)vs, AttributeValue.AttributeList$.MODULE$.show()).show()));
            }
            return acc.putAttributeMap(k, builder.build());
        })).build();
    }

    private final Status toStatusProto$1(SpanStatus status) {
        return Status.newBuilder().setCode(status.canonicalCode()).build();
    }

    private final Span.Links.Builder toLinksProto$1$$anonfun$1() {
        return Span.Links.newBuilder();
    }

    private final Span.Links toLinksProto$4(Option links) {
        return ((Span.Links.Builder)links.fold(this::toLinksProto$1$$anonfun$1, (Function1 & Serializable)_$3 -> (Span.Links.Builder)_$3.foldLeft((Object)Span.Links.newBuilder(), (Function2 & Serializable)(builder, link) -> builder.addLink(Span.Link.newBuilder().setType(Span.Link$.Type.PARENT_LINKED_SPAN).setTraceId(package.show$.MODULE$.toShow((Object)new TraceId(link.traceId()), TraceId$.MODULE$.show()).show()).setSpanId(package.show$.MODULE$.toShow((Object)new SpanId(link.spanId()), SpanId$.MODULE$.show()).show()))))).build();
    }

    private final Span.Builder $anonfun$3(Span.Builder spanBuilder$1) {
        return spanBuilder$1;
    }

    private final Span convert$1(String projectId$1, CompletedSpan completedSpan) {
        String spanIdHex = package.show$.MODULE$.toShow((Object)new SpanId(completedSpan.context().spanId()), SpanId$.MODULE$.show()).show();
        SpanName spanName = SpanName.newBuilder().setProject(projectId$1).setTrace(package.show$.MODULE$.toShow((Object)new TraceId(completedSpan.context().traceId()), TraceId$.MODULE$.show()).show()).setSpan(spanIdHex).build();
        Span.Builder spanBuilder = Span.newBuilder().setName(spanName.toString()).setSpanId(spanIdHex).setDisplayName(this.toTruncatableStringProto$1(this.toDisplayName$1(completedSpan.name(), completedSpan.kind()))).setStartTime(this.toTimestampProto$1(completedSpan.start())).setEndTime(this.toTimestampProto$1(completedSpan.end())).setAttributes(this.toAttributesProto$2(completedSpan.allAttributes())).setStatus(this.toStatusProto$1(completedSpan.status())).setLinks(this.toLinksProto$4(completedSpan.links()));
        Span.Builder builder = (Span.Builder)completedSpan.context().parent().fold(() -> this.$anonfun$3(spanBuilder), (Function1 & Serializable)parent -> spanBuilder.setParentSpanId(package.show$.MODULE$.toShow((Object)new SpanId(parent.spanId()), SpanId$.MODULE$.show()).show()).setSameProcessAsParentSpan(BoolValue.of((!parent.isRemote() ? 1 : 0) != 0)));
        return builder.build();
    }

    private final Object liftApiFuture$6(Async evidence$1$1, Object ffa) {
        return package.flatMap$.MODULE$.toFlatMapOps(ffa, (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)fut -> package.flatMap$.MODULE$.toFlatMapOps(Async$.MODULE$.apply(evidence$1$1).executionContext(), (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)ec -> package.functor$.MODULE$.toFunctorOps(Async$.MODULE$.apply(evidence$1$1).async_((Function1)(JProcedure1 & Serializable)cb -> ApiFutures.addCallback((ApiFuture)fut, (ApiFutureCallback)new ApiFutureCallback<A>((Function1)cb){
            private final Function1 cb$1;
            {
                this.cb$1 = cb$2;
            }

            public void onFailure(Throwable t) {
                this.cb$1.apply((Object)scala.package$.MODULE$.Left().apply((Object)t));
            }

            public void onSuccess(Object result) {
                this.cb$1.apply((Object)scala.package$.MODULE$.Right().apply(result));
            }
        }, runnable -> ec.execute(runnable))), (Functor)evidence$1$1).map((Function1 & Serializable)a -> a)));
    }

    private final BatchWriteSpansRequest write$2$$anonfun$2(String projectId$3, Foldable evidence$2$2, ProjectName projectName$2, Object spans$1) {
        return BatchWriteSpansRequest.newBuilder().setName(projectName$2.toString()).addAllSpans((Iterable)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)package.foldable$.MODULE$.toFoldableOps(spans$1, evidence$2$2).foldLeft((Object)ListBuffer$.MODULE$.empty(), (Function2 & Serializable)(buf, span) -> (ListBuffer)buf.$plus$eq((Object)this.convert$1(projectId$3, (CompletedSpan)span)))).asJava()).build();
    }

    private final ApiFuture write$3$$anonfun$3$$anonfun$1(TraceServiceClient client$2, BatchWriteSpansRequest request$1) {
        return client$2.batchWriteSpansCallable().futureCall((Object)request$1);
    }

    public final Object io$janstenpickle$trace4cats$stackdriver$StackdriverGrpcSpanExporter$$$_$write$6(String projectId$2, Async evidence$1$4, Foldable evidence$2$1, ProjectName projectName$1, TraceServiceClient client, Object spans) {
        return package.flatMap$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply((Sync)evidence$1$4).delay(() -> this.write$2$$anonfun$2(projectId$2, evidence$2$1, projectName$1, spans)), (FlatMap)evidence$1$4).flatMap((Function1 & Serializable)request -> package.functor$.MODULE$.toFunctorOps(this.liftApiFuture$6(evidence$1$4, Sync$.MODULE$.apply((Sync)evidence$1$4).delay(() -> this.write$3$$anonfun$3$$anonfun$1(client, request))), (Functor)evidence$1$4).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Empty empty = x$1;
        }));
    }

    private final void apply$$anonfun$3$$anonfun$1(TraceServiceClient client$3) {
        client$3.shutdown();
    }
}

