/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.convert;

import io.jafka.jeos.convert.DataType;
import io.jafka.jeos.convert.TokenFunction;
import io.jafka.jeos.core.request.chain.json2bin.CreateAccountArg;
import io.jafka.jeos.core.request.chain.json2bin.TransferArg;
import io.jafka.jeos.util.ByteArrayBuffer;
import io.jafka.jeos.util.ecc.Hex;

public class Packer {
    public static String packTransfer(TransferArg arg) {
        ByteArrayBuffer buff = new ByteArrayBuffer(128);
        buff.append(DataType.name.encode(arg.getFrom(), TokenFunction.transfer));
        buff.append(DataType.name.encode(arg.getTo(), TokenFunction.transfer));
        buff.append(DataType.asset.encode(arg.getQuantity(), TokenFunction.transfer));
        buff.append(DataType.string.encode(arg.getMemo(), TokenFunction.transfer));
        return Hex.bytesToHexString(buff.toByteArray());
    }

    public static String packCreateAccount(CreateAccountArg arg) {
        ByteArrayBuffer buff = new ByteArrayBuffer(128);
        buff.append(DataType.name.encode(arg.getCreator(), TokenFunction.account));
        buff.append(DataType.name.encode(arg.getName(), TokenFunction.account));
        arg.getOwner().getKeys().stream().forEach(k -> buff.append(DataType.key.encode(k.getKey(), TokenFunction.account)));
        arg.getActive().getKeys().stream().forEach(k -> buff.append(DataType.key.encode(k.getKey(), TokenFunction.account)));
        return Hex.bytesToHexString(buff.toByteArray());
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Packer.packTransfer(new TransferArg("shijiebangmm", "womenshi1111", "1.0000 EOS", "\u6211\u662f\u4e2d\u56fd\u4eba")));
    }
}

