/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.util;

import io.jafka.jeos.util.Base58;
import io.jafka.jeos.util.ByteArrayBuffer;
import io.jafka.jeos.util.ecc.Hex;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Raw {
    final ByteArrayBuffer s;

    public Raw() {
        this.s = new ByteArrayBuffer(32);
    }

    public Raw(ByteArrayBuffer s) {
        this.s = s;
    }

    public Raw packVarint32(long v) {
        while (v >= 128L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            this.s.append(b);
            v >>>= 7;
        }
        this.s.append((byte)v);
        return this;
    }

    public Raw pack(int v) {
        byte[] b = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(v).array();
        this.s.append(b);
        return this;
    }

    public Raw packUint64(long v) {
        byte[] b = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(v).array();
        this.s.append(b);
        return this;
    }

    public Raw packUint32(long v) {
        byte[] b = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt((int)v).array();
        this.s.append(b);
        return this;
    }

    public Raw packUint16(int v) {
        this.s.append((byte)(v & 0xFF));
        this.s.append((byte)((v & 0xFF00) >>> 8));
        return this;
    }

    public Raw packUint8(int v) {
        this.s.append((byte)(v & 0xFF));
        return this;
    }

    public Raw pack(String str) {
        byte[] dat = str.getBytes(StandardCharsets.UTF_8);
        this.packVarint32(dat.length);
        this.s.append(dat);
        return this;
    }

    public Raw pack(Collection<String> strs) {
        this.packVarint32(strs.size());
        strs.stream().forEach(this::pack);
        return this;
    }

    public Raw packPublicKey(String key) {
        if (key.startsWith("EOS")) {
            key = key.substring(3);
        }
        byte[] b = Base58.decode(key);
        this.s.append((byte)0);
        this.s.append(b, 0, b.length - 4);
        return this;
    }

    public Raw pack(byte[] bytes) {
        this.s.append(bytes);
        return this;
    }

    public byte[] bytes() {
        return this.s.toByteArray();
    }

    public String toHex() {
        return Hex.toHex(this.bytes());
    }

    public static int charidx(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 6;
        }
        if (c >= '1' && c <= '5') {
            return c - 49 + 1;
        }
        return 0;
    }

    public Raw packName(String n) {
        StringBuilder bits = new StringBuilder(64);
        for (int i = 0; i <= 12; ++i) {
            int c = i < n.length() ? Raw.charidx(n.charAt(i)) : 0;
            int bitlen = i < 12 ? 5 : 4;
            String _b = Integer.toBinaryString(c);
            for (int j = 0; j < bitlen - _b.length(); ++j) {
                bits.append('0');
            }
            bits.append(_b);
        }
        BigInteger vname = new BigInteger(bits.toString(), 2);
        byte[] b = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(vname.longValue()).array();
        this.s.append(b);
        return this;
    }

    public Raw packAsset(String v) {
        Pattern p = Pattern.compile("(\\d+\\.?(\\d*)) (.+)");
        Matcher m = p.matcher(v);
        if (!m.matches()) {
            throw new RuntimeException("ERROR assert format");
        }
        long amount = Long.parseLong(m.group(1).replaceAll("\\.", ""));
        int precision = m.group(2).length();
        String symbol = m.group(3);
        this.s.append(amount);
        this.s.append((byte)precision);
        this.s.append(symbol.getBytes());
        for (int i = 0; i < 7 - symbol.length(); ++i) {
            this.s.append(0);
        }
        return this;
    }

    public String toString() {
        return this.toHex();
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] copy(byte[] src, int start, int length) {
        byte[] c = new byte[length];
        System.arraycopy(src, start, c, 0, length);
        return c;
    }
}

