/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.util;

import io.jafka.jeos.util.Base58;
import io.jafka.jeos.util.Raw;
import io.jafka.jeos.util.SHA;
import io.jafka.jeos.util.ecc.Ecdsa;
import io.jafka.jeos.util.ecc.Hex;
import io.jafka.jeos.util.ecc.Point;
import io.jafka.jeos.util.ecc.Ripemd160;
import io.jafka.jeos.util.ecc.Secp256k;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;

public class KeyUtil {
    public static final String address_prefix = "EOS";
    public static final Secp256k secp = new Secp256k();

    public static String createPrivateKey() {
        return KeyUtil.createPrivateKey(UUID.randomUUID().toString());
    }

    public static String createPrivateKey(String seed) {
        Objects.requireNonNull(seed);
        byte[] a = new byte[]{-128};
        byte[] b = new BigInteger(SHA.sha256(seed)).toByteArray();
        byte[] private_key = Raw.concat(a, b);
        byte[] checksum = SHA.sha256(private_key);
        checksum = SHA.sha256(checksum);
        byte[] check = Raw.copy(checksum, 0, 4);
        byte[] pk = Raw.concat(private_key, check);
        return Base58.encode(pk);
    }

    private static BigInteger privateKey(String pk) {
        byte version;
        byte[] private_wif = Base58.decode(pk);
        if (private_wif[0] != (version = -128)) {
            throw new IllegalArgumentException("Expected version 128, instead got " + version);
        }
        byte[] private_key = Raw.copy(private_wif, 0, private_wif.length - 4);
        byte[] new_checksum = SHA.sha256(private_key);
        new_checksum = SHA.sha256(new_checksum);
        new_checksum = Raw.copy(new_checksum, 0, 4);
        byte[] last_private_key = Raw.copy(private_key, 1, private_key.length - 1);
        BigInteger d = new BigInteger(Hex.toHex(last_private_key), 16);
        return d;
    }

    public static String toPublicKey(String privateKey) {
        Objects.requireNonNull(privateKey);
        BigInteger d = KeyUtil.privateKey(privateKey);
        Point ep = secp.G().multiply(d);
        byte[] pub_buf = ep.getEncoded();
        byte[] csum = Ripemd160.from(pub_buf).bytes();
        csum = Raw.copy(csum, 0, 4);
        byte[] addy = Raw.concat(pub_buf, csum);
        StringBuffer bf = new StringBuffer(address_prefix);
        bf.append(Base58.encode(addy));
        return bf.toString();
    }

    public static String signHash(String pk, byte[] b) {
        Ecdsa.SignBigInt sign;
        byte lenS;
        byte lenR;
        String dataSha256 = Hex.toHex(SHA.sha256(b));
        BigInteger e = new BigInteger(dataSha256, 16);
        int nonce = 0;
        int i = 0;
        BigInteger d = KeyUtil.privateKey(pk);
        Point Q = secp.G().multiply(d);
        nonce = 0;
        Ecdsa ecd = new Ecdsa(secp);
        do {
            sign = ecd.sign(dataSha256, d, nonce++);
            byte[] der = sign.getDer();
            lenR = der[3];
            lenS = der[5 + lenR];
        } while (lenR != 32 || lenS != 32);
        i = ecd.calcPubKeyRecoveryParam(e, sign, Q);
        i += 4;
        byte[] pub_buf = new byte[65];
        pub_buf[0] = (byte)(i += 27);
        System.arraycopy(sign.getR().toByteArray(), 0, pub_buf, 1, sign.getR().toByteArray().length);
        System.arraycopy(sign.getS().toByteArray(), 0, pub_buf, sign.getR().toByteArray().length + 1, sign.getS().toByteArray().length);
        byte[] checksum = Ripemd160.from(Raw.concat(pub_buf, "K1".getBytes())).bytes();
        byte[] signatureString = Raw.concat(pub_buf, Raw.copy(checksum, 0, 4));
        return "SIG_K1_" + Base58.encode(signatureString);
    }
}

