/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.util.ecc;

import io.jafka.jeos.util.ecc.Curve;
import io.jafka.jeos.util.ecc.FieldElement;
import java.math.BigInteger;

public class Point {
    private Curve curve;
    private FieldElement x;
    private FieldElement y;
    private boolean compressed;

    public Point(Curve curve, FieldElement x, FieldElement y, boolean compressed) {
        this.curve = curve;
        this.x = x;
        this.y = y;
        this.compressed = compressed;
    }

    public Point(Curve curve, FieldElement x, FieldElement y) {
        this(curve, x, y, true);
    }

    public Curve getCurve() {
        return this.curve;
    }

    public FieldElement getX() {
        return this.x;
    }

    public FieldElement getY() {
        return this.y;
    }

    public boolean isInfinity() {
        return this.x == null && this.y == null;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public byte[] getEncoded() {
        if (this.isInfinity()) {
            return new byte[1];
        }
        int length = Point.getByteLength(this.x.getFieldSize());
        if (this.compressed) {
            int PC = this.getY().toBigInteger().testBit(0) ? 3 : 2;
            byte[] X = Point.integerToBytes(this.getX().toBigInteger(), length);
            byte[] PO = new byte[X.length + 1];
            PO[0] = PC;
            System.arraycopy(X, 0, PO, 1, X.length);
            return PO;
        }
        byte[] X = Point.integerToBytes(this.getX().toBigInteger(), length);
        byte[] Y = Point.integerToBytes(this.getY().toBigInteger(), length);
        byte[] PO = new byte[X.length + Y.length + 1];
        PO[0] = 4;
        System.arraycopy(X, 0, PO, 1, X.length);
        System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
        return PO;
    }

    public Point add(Point b) {
        if (this.isInfinity()) {
            return b;
        }
        if (b.isInfinity()) {
            return this;
        }
        if (this.x.equals(b.x)) {
            if (this.y.equals(b.y)) {
                return this.twice();
            }
            return this.curve.getInfinity();
        }
        FieldElement gamma = b.y.subtract(this.y).divide(b.x.subtract(this.x));
        FieldElement x3 = gamma.square().subtract(this.x).subtract(b.x);
        FieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
        return new Point(this.curve, x3, y3);
    }

    public Point twice() {
        if (this.isInfinity()) {
            return this;
        }
        if (this.y.toBigInteger().signum() == 0) {
            return this.curve.getInfinity();
        }
        FieldElement TWO = this.curve.fromBigInteger(BigInteger.valueOf(2L));
        FieldElement THREE = this.curve.fromBigInteger(BigInteger.valueOf(3L));
        FieldElement gamma = this.x.square().multiply(THREE).add(this.curve.getA()).divide(this.y.multiply(TWO));
        FieldElement x3 = gamma.square().subtract(this.x.multiply(TWO));
        FieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
        return new Point(this.curve, x3, y3, this.compressed);
    }

    public Point subtract(Point b) {
        if (b.isInfinity()) {
            return this;
        }
        return this.add(b.negate());
    }

    public Point negate() {
        return new Point(this.curve, this.x, this.y.negate(), this.compressed);
    }

    public Point multiply(BigInteger k) {
        BigInteger e = k;
        BigInteger h = e.multiply(BigInteger.valueOf(3L));
        Point neg = this.negate();
        Point R = this;
        for (int i = h.bitLength() - 2; i > 0; --i) {
            boolean eBit;
            R = R.twice();
            boolean hBit = h.testBit(i);
            if (hBit == (eBit = e.testBit(i))) continue;
            R = R.add(hBit ? this : neg);
        }
        return R;
    }

    public Point multiplyTwo(BigInteger j, Point x, BigInteger k) {
        Point R = this.curve.getInfinity();
        Point both = this.add(x);
        for (int i = Math.max(j.bitLength(), k.bitLength()) - 1; i >= 0; --i) {
            Boolean jBit = j.testBit(i);
            Boolean kBit = k.testBit(i);
            R = R.twice();
            if (jBit.booleanValue()) {
                if (kBit.booleanValue()) {
                    R = R.add(both);
                    continue;
                }
                R = R.add(this);
                continue;
            }
            if (!kBit.booleanValue()) continue;
            R = R.add(x);
        }
        return R;
    }

    public static int getByteLength(int fieldSize) {
        return (fieldSize + 7) / 8;
    }

    public static byte[] integerToBytes(BigInteger s, int length) {
        byte[] bytes = s.toByteArray();
        if (length < bytes.length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, bytes.length - tmp.length, tmp, 0, tmp.length);
            return tmp;
        }
        if (length > bytes.length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Point)) {
            return false;
        }
        Point o = (Point)other;
        if (this.isInfinity()) {
            return o.isInfinity();
        }
        return this.x.equals(o.x) && this.y.equals(o.y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }
}

