/*
 * Decompiled with CFR 0.152.
 */
package io.jafka.jeos.impl;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);
    static AtomicLong _seq = new AtomicLong(0L);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long index = _seq.incrementAndGet();
        long t1 = System.currentTimeMillis();
        log.info("OkHttp-{}-1-->head {} {}", new Object[]{index, request.url(), request.headers()});
        if (request.body() != null) {
            Buffer requestBuffer = new Buffer();
            request.body().writeTo((BufferedSink)requestBuffer);
            log.info("OkHttp-{}-2-->body {}", (Object)index, (Object)requestBuffer.readUtf8());
        }
        Response response = chain.proceed(request);
        long t2 = System.currentTimeMillis();
        log.info("OkHttp-{}-3--<head {} {}ms {}", new Object[]{index, request.url(), t2 - t1, response.headers()});
        MediaType contentType = response.body().contentType();
        String content = response.body().string();
        log.info("OkHttp-{}-4--<body {}", (Object)index, (Object)content);
        ResponseBody wrappedBody = ResponseBody.create((MediaType)contentType, (String)content);
        return response.newBuilder().body(wrappedBody).build();
    }
}

