/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.micrometer;

import io.jaegertracing.metrics.Gauge;
import io.jaegertracing.metrics.MetricsFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MicrometerMetricsFactory
implements MetricsFactory {
    public io.jaegertracing.metrics.Counter createCounter(final String name, final Map<String, String> tags) {
        return new io.jaegertracing.metrics.Counter(){
            private final Counter counter;
            {
                this.counter = Metrics.counter((String)name, (Iterable)MicrometerMetricsFactory.this.translateTags(tags));
            }

            public void inc(long delta) {
                this.counter.increment((double)delta);
            }
        };
    }

    public io.jaegertracing.metrics.Timer createTimer(final String name, final Map<String, String> tags) {
        return new io.jaegertracing.metrics.Timer(){
            private final Timer timer;
            {
                this.timer = Metrics.timer((String)name, (Iterable)MicrometerMetricsFactory.this.translateTags(tags));
            }

            public void durationMicros(long time) {
                this.timer.record(time, TimeUnit.MICROSECONDS);
            }
        };
    }

    public Gauge createGauge(final String name, final Map<String, String> tags) {
        return new Gauge(){
            private final Iterable<Tag> translatedTags;
            {
                this.translatedTags = MicrometerMetricsFactory.this.translateTags(tags);
            }

            public void update(long amount) {
                Metrics.gauge((String)name, this.translatedTags, (Number)amount);
            }
        };
    }

    private Iterable<Tag> translateTags(Map<String, String> tags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>(tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            tagList.add((Tag)new ImmutableTag(tag.getKey(), tag.getValue()));
        }
        return tagList;
    }
}

